/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleCsvConnection;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleCsvDataSourceUxWizard;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleCsvDataTable;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleDriveDataSource;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="goCsvDS")
public class OlapBuilderGoogleCsvDataSource
extends OlapBuilderGoogleDriveDataSource<OlapBuilderGoogleCsvConnection> {
    protected String getReportDataSourceType() {
        return "googleCsv";
    }

    protected String getReportDataSourceTypeCaption() {
        return "Google CSV";
    }

    public boolean isDiscoverTablesSupported() {
        return true;
    }

    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return null;
    }

    public OlapBuilderGoogleCsvDataTable createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderGoogleCsvDataTable(tableName);
    }

    public List<String> discoverAllTablesNames(OlapBuilderGoogleCsvConnection connection, boolean filterSystemSchemas, @Nullable String filter) {
        try {
            return connection.getFileNames(filter);
        }
        catch (IOException e) {
            throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_OAUTH_IO_ERROR, new Serializable[]{e.getLocalizedMessage()});
        }
    }

    public OlapBuilderGoogleCsvConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return new OlapBuilderGoogleCsvConnection(this);
    }

    protected UxBuilderDataSourceType createUxType() {
        return new UxBuilderDataSourceType(this.getTypeId(), this.getUxTypeImage(), () -> new OlapBuilderGoogleCsvDataSourceUxWizard(this, this.getTypeId()));
    }
}

