/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.common;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import crazydev.iccube.builder.googleapi.common.OlapBuilderWizardWebTokenUxModel;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.ux.meta.common.model.UxAutomodel;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.plugin.UxBuilderGADataSourceAuthorizationType;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OlapBuilderGoogleDataSourceUxWizard<DS extends OlapBuilderGoogleApiDataSource, WEBTOKEN_MODEL1, WEBTOKEN_MODEL2 extends OlapBuilderWizardWebTokenUxModel>
extends UxBuilderCreateTypedDataSourceWizard {
    protected final DS ds;

    public OlapBuilderGoogleDataSourceUxWizard(String dataSourceTypeId, List<UxBuilderWizardStep> steps, DS datasource) {
        super(dataSourceTypeId, steps);
        this.ds = datasource;
    }

    public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
        int base = 0;
        if (this.isGoogleOAuthDisabled(context)) {
            ++base;
        }
        return this.onServiceAccountWizard(context, activeStep, base + 1);
    }

    private UxBuilderWizardValidation onServiceAccountWizard(OlapRuntimeContext context, int activeStep, int base) {
        if (activeStep + base == 1) {
            return this.onServiceAccount(context, activeStep);
        }
        if (activeStep + base == 2) {
            return this.onServiceAccountScope(context, activeStep);
        }
        return null;
    }

    public IOlapBuilderDataSource getDataSourceFromUI() {
        UxBuilderGADataSourceAuthorizationType authType = (UxBuilderGADataSourceAuthorizationType)this.getStepModelFor(UxBuilderGADataSourceAuthorizationType.class);
        if (authType != null && authType.getAuthorizationTypeType() != UxBuilderGADataSourceAuthorizationType.AuthorizationType.ServiceAccount) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        OlapBuilderGoogleApiDataSource gaDS = this.getDataSourceForServiceAccountUI();
        return gaDS;
    }

    @NotNull
    private OlapBuilderGoogleApiDataSource getDataSourceForServiceAccountUI() {
        OlapBuilderGoogleApiDataSource gaDS = this.getDataSourceFromUIForServiceAccount();
        ServiceAccountProperties serviceAccountProperties = (ServiceAccountProperties)this.getStepModelFor(ServiceAccountProperties.class);
        gaDS.setServiceAccount(serviceAccountProperties);
        UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)this.getStepModelFor(UxBuilderDataSourceNameForm.class);
        gaDS.setNameAndDescription(name.getName(), name.getDescription());
        return gaDS;
    }

    private UxBuilderWizardValidation onServiceAccountScope(OlapRuntimeContext context, int activeStep) {
        ServiceAccountProperties dataSource = (ServiceAccountProperties)this.getStepModelFor(ServiceAccountProperties.class);
        try {
            OlapFile file = context.getRootFileSystem().create(dataSource.serviceAccountPrivateKey);
            if (file.isDirectory()) {
                throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_OAUTH_IO_ERROR, new Serializable[]{"'" + dataSource.serviceAccountPrivateKey + "' file is a directory"});
            }
            if (!file.exists()) {
                throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_OAUTH_IO_ERROR, new Serializable[]{"'" + dataSource.serviceAccountPrivateKey + "' file does not exists"});
            }
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException(OlapGoogleApiError.GOOGLE_OAUTH_IO_ERROR, new Serializable[]{"'" + dataSource.serviceAccountPrivateKey + "' is not a valid file"});
        }
        ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
        newSteps.add(UxBuilderCreateDataSourceWizardSteps.props((String)this.getModel1LocalizationTag(), (Object)this.createScopeModelForService(), (boolean)false));
        return new UxBuilderWizardValidation(activeStep, newSteps);
    }

    public boolean isGoogleOAuthDisabled(OlapRuntimeContext context) {
        return CdStringUtils.isNullOrBlank((String)context.getUserDefinedProperty("google.oauth2.secretFile"));
    }

    protected UxBuilderWizardValidation onServiceAccount(OlapRuntimeContext context, int activeStep) {
        return new UxBuilderWizardValidation(activeStep, Collections.singletonList(UxBuilderCreateDataSourceWizardSteps.props((boolean)true, (Object)new ServiceAccountProperties())));
    }

    @NotNull
    protected String getModel1LocalizationTag() {
        return "steps.model1";
    }

    @NotNull
    protected abstract WEBTOKEN_MODEL1 createWebTokenModel();

    @NotNull
    protected Object createScopeModelForService() {
        return this.createWebTokenModel();
    }

    public abstract OlapBuilderGoogleApiDataSource getDataSourceFromUIForWebtoken();

    protected OlapBuilderGoogleApiDataSource getDataSourceFromUIForServiceAccount() {
        return this.getDataSourceFromUIForWebtoken();
    }

    protected static List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.nameWithValidation());
        steps.add(UxBuilderCreateDataSourceWizardSteps.more());
        return steps;
    }

    public static class ServiceAccountProperties
    implements UxAutomodel {
        public static final CdProperty SERVICE_ACCOUNT_PRIVATE_KEY = new CdReadWriteProperty(ServiceAccountProperties.class, "serviceAccountPrivateKey", true){

            public Class<?> getTypeForDefaultEditor() {
                return File.class;
            }
        };
        @XmlAttribute
        protected String serviceAccountPrivateKey;
    }
}

