/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.googleapi.authorization.GoogleCredentialServiceAccountBuilder;
import crazydev.iccube.builder.googleapi.authorization.OlapBuilderGoogleCredentialBuilder;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleDataSourceUxWizard;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderGoogleApiDataSource<CONNECTION extends IOlapBuilderConnection>
extends OlapBuilderBaseDataSource<CONNECTION> {
    public static final String CREDENTIALS = "group.credentials";
    public static final CdProperty SERVICE_ACCOUNT_PRIVATE_KEY = new CdReadWriteProperty(OlapBuilderGoogleApiDataSource.class, "serviceAccountPrivateKey", false){

        public Class<?> getTypeForDefaultEditor() {
            return File.class;
        }

        public String getGroupName() {
            return OlapBuilderGoogleApiDataSource.CREDENTIALS;
        }
    };
    static final String GOOGLE_OAUTH2_PROPERTY = "google.oauth2.secretFile";
    @XmlAttribute
    protected String serviceAccountPrivateKey;

    public OlapBuilderGoogleApiDataSource(String serviceAccountPrivateKey) {
        this.serviceAccountPrivateKey = serviceAccountPrivateKey;
    }

    public OlapBuilderGoogleApiDataSource() {
    }

    public UxBuilderDataSourceTypeGroupId getUxGroupId() {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupGoogle;
    }

    public String getServiceAccountPrivateKey() {
        return this.serviceAccountPrivateKey;
    }

    @Nullable
    public Integer getTimeout() {
        return null;
    }

    public OlapBuilderGoogleCredentialBuilder getCredentialBuilder(OlapRuntimeContext context) {
        return new GoogleCredentialServiceAccountBuilder(this.serviceAccountPrivateKey);
    }

    public void setServiceAccount(OlapBuilderGoogleDataSourceUxWizard.ServiceAccountProperties props) {
        this.serviceAccountPrivateKey = props.serviceAccountPrivateKey;
    }
}

