/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdSql;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderBigQueryStatementDataTableValidator;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryBaseDataTable;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="goBigqueryStatementDT")
public class OlapBuilderGoogleBigqueryStatementDataTable
extends OlapBuilderGoogleBigqueryBaseDataTable
implements IOlapBuilderJaxbListener {
    public static final CdProperty STATEMENT = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "statement", true){

        public Class<?> getTypeForDefaultEditor() {
            return CdSql.class;
        }
    };
    public static final CdProperty STATEMENT_INCREMENTAL = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "statementIncremental", false){

        public boolean isForIncrLoad() {
            return true;
        }

        public Class<?> getTypeForDefaultEditor() {
            return CdSql.class;
        }
    };
    public static final CdProperty USE_LEGACY_CODE = new CdReadWriteProperty(OlapBuilderGoogleBigqueryStatementDataTable.class, "useLegacyCode", true);
    @XmlAttribute(required=true)
    protected String statement;
    @XmlAttribute(required=false)
    protected String statementIncremental;
    @XmlAttribute
    protected Boolean useLegacyCode = false;

    public OlapBuilderGoogleBigqueryStatementDataTable() {
    }

    public OlapBuilderGoogleBigqueryStatementDataTable(String tableName, String statement) {
        super(tableName);
        this.statement = statement;
    }

    public boolean isNameReadOnly() {
        return false;
    }

    public boolean isDiscoveredInDataSource() {
        return false;
    }

    public String getInternalFriendlyTypeName() {
        return "Google BigQuery Statement";
    }

    @Override
    protected boolean useLegacyCode() {
        return this.useLegacyCode == null || this.useLegacyCode != false || this.statement.startsWith("#legacySQL");
    }

    @Override
    protected String buildSelect(OlapBuilderGoogleBigqueryConnection connection, @Nullable Comparable incrLoadMarker) {
        if (incrLoadMarker != null) {
            if (CdStringUtils.isNotNullAndNotBlank((String)this.statementIncremental)) {
                String restriction = this.setupIncrLoadRestrictionValue(this.getName(), incrLoadMarker);
                return this.statementIncremental.replace("?", restriction);
            }
            String restriction = this.setupIncrLoadRestriction(this.getName(), incrLoadMarker);
            return "SELECT * FROM (" + this.statement + ") temp WHERE " + restriction;
        }
        return this.statement;
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderGoogleBigqueryConnection>, IOlapBuilderDataTableDef<OlapBuilderGoogleBigqueryConnection>> getValidator() {
        return new OlapBuilderBigQueryStatementDataTableValidator();
    }

    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderGoogleBigqueryStatementDataTable tableUpdate = (OlapBuilderGoogleBigqueryStatementDataTable)newTable;
        return !Objects.equals(this.statement, tableUpdate.statement);
    }

    public void beforeMarshal() {
    }

    public void afterUnmarshal() {
        this.useLegacyCode = this.useLegacyCode == null || this.useLegacyCode != false;
    }
}

