/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.ViewDefinition;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigQueryDataSourceUxWizard;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryBaseDataTable;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataTable;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryStatementDataTable;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="goBigqueryDS")
public class OlapBuilderGoogleBigqueryDataSource
extends OlapBuilderGoogleApiDataSource<OlapBuilderGoogleBigqueryConnection> {
    public static final CdProperty PROJECT = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataSource.class, "projectId", true);
    public static final CdProperty CREDENTIALS_PROJECT = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataSource.class, "credentialsProjectId", false){

        public String getGroupName() {
            return "group.credentials";
        }
    };
    public static final CdProperty DATASET = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataSource.class, "datasetId", false);
    public static final CdProperty TIME_OUT = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataSource.class, "waitTime", false);
    public static final CdProperty TOKEN_SUBSCOPE = new CdReadWriteProperty(OlapBuilderGoogleBigqueryDataSource.class, "tokenSubscope", false);
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderGoogleBigqueryStatementDataTable.class);
    @XmlTransient
    private final Map<String, TableInfo> discoveredTables = new ConcurrentHashMap<String, TableInfo>();
    @XmlAttribute(required=false)
    public String projectId;
    @XmlAttribute(required=false)
    public String credentialsProjectId;
    @XmlAttribute(required=false)
    public String datasetId;
    @XmlTransient
    private long discoveredTablesMs = -1L;
    @XmlAttribute(required=false)
    @Nullable
    private Integer waitTime;
    @XmlAttribute(required=false)
    private String tokenSubscope;

    public OlapBuilderGoogleBigqueryDataSource() {
    }

    public OlapBuilderGoogleBigqueryDataSource(String serviceAccountPrivateKey) {
        super(serviceAccountPrivateKey);
    }

    protected String getReportDataSourceType() {
        return "googleBigQuery";
    }

    protected String getReportDataSourceTypeCaption() {
        return "Google Big Query";
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCredentialsProjectId() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.credentialsProjectId) ? this.credentialsProjectId : this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public boolean isDiscoverTablesSupported() {
        return true;
    }

    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return CREATED_TABLE_TYPES;
    }

    public OlapBuilderGoogleBigqueryConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return new OlapBuilderGoogleBigqueryConnection(this);
    }

    public OlapBuilderGoogleBigqueryBaseDataTable createEmptyDiscoverTable(String tableName) {
        TableInfo info = this.discoveredTables.get(tableName);
        if (info == null) {
            throw new RuntimeException("Unable to find table '" + tableName + "' in definition");
        }
        return new OlapBuilderGoogleBigqueryDataTable(tableName, info.tableName, OlapBuilderGoogleBigqueryDataSource.nullIfSame(info.dsName, this.datasetId), info.useLegacy);
    }

    private static String nullIfSame(String first, String check) {
        return first == null || first.equals(check) ? null : first;
    }

    public OlapBuilderBaseDataTable<OlapBuilderGoogleBigqueryConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        return new OlapBuilderGoogleBigqueryStatementDataTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> discoverAllTablesNames(OlapBuilderGoogleBigqueryConnection connection, boolean filterSystemSchemas, @Nullable String filter) {
        ArrayList<String> tableNames = new ArrayList<String>();
        OlapBuilderGoogleBigqueryDataSource olapBuilderGoogleBigqueryDataSource = this;
        synchronized (olapBuilderGoogleBigqueryDataSource) {
            if (this.discoveredTablesMs > 0L && System.currentTimeMillis() - this.discoveredTablesMs < 60000L) {
                this.discoveredTables.keySet().forEach(tableName -> {
                    if (this.matches(filter, (String)tableName)) {
                        tableNames.add((String)tableName);
                    }
                });
                this.discoveredTablesMs = System.currentTimeMillis();
            } else {
                this.discoveredTables.clear();
                BigQuery bigQuery = connection.createJsonClientForDiscover();
                if (CdStringUtils.isNotNullAndNotBlank((String)this.datasetId)) {
                    Dataset dataset2 = bigQuery.getDataset(this.datasetId, new BigQuery.DatasetOption[0]);
                    this.discoverTables(dataset2, tableNames, filter, true);
                } else {
                    bigQuery.listDatasets(new BigQuery.DatasetListOption[0]).iterateAll().forEach(dataset -> this.discoverTables((Dataset)dataset, (List<String>)tableNames, filter, false));
                }
                this.discoveredTablesMs = -1L;
                if (CdStringUtils.isNullOrBlank((String)filter)) {
                    this.discoveredTablesMs = System.currentTimeMillis();
                }
            }
        }
        return tableNames;
    }

    private void discoverTables(Dataset dataset, List<String> tableNames, @Nullable String filter, boolean singleDataSet) {
        dataset.list(new BigQuery.TableListOption[0]).iterateAll().forEach(table -> {
            TableId tableId;
            String tableNameForUser;
            boolean useLegacy = false;
            if (table.getDefinition() instanceof ViewDefinition) {
                ViewDefinition definition = (ViewDefinition)table.getDefinition();
                useLegacy = definition.useLegacySql() == Boolean.TRUE;
            }
            if (this.matches(filter, tableNameForUser = (String)(singleDataSet ? "" : tableId.getDataset() + ".") + (tableId = table.getTableId()).getTable())) {
                this.discoveredTables.put(tableNameForUser, new TableInfo(tableId, useLegacy));
                tableNames.add(tableNameForUser);
            }
        });
    }

    private boolean matches(@Nullable String filter, String tableNameForUser) {
        return filter == null || tableNameForUser.contains(filter);
    }

    @Nullable
    public Integer getWaitTime() {
        return this.waitTime;
    }

    protected UxBuilderDataSourceType createUxType() {
        return new UxBuilderDataSourceType(this.getTypeId(), this.getUxTypeImage(), () -> new OlapBuilderGoogleBigQueryDataSourceUxWizard(this, this.getTypeId()));
    }

    public String getTokenSubscope() {
        return this.tokenSubscope;
    }

    public void setTokenSubscope(String bqTokenSubscope) {
        this.tokenSubscope = bqTokenSubscope;
    }

    private static class TableInfo {
        final String tableName;
        final String dsName;
        final boolean useLegacy;

        public TableInfo(TableId tableId, boolean useLegacy) {
            this.tableName = tableId.getTable();
            this.dsName = tableId.getDataset();
            this.useLegacy = useLegacy;
        }
    }
}

