/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryDataSource;
import crazydev.iccube.builder.googleapi.common.OlapBuilderGoogleApiConnection;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.request.IcCubeRequest;
import java.io.Serializable;

public class OlapBuilderGoogleBigqueryConnection
extends OlapBuilderGoogleApiConnection<BigQuery, OlapBuilderGoogleBigqueryDataSource> {
    private Credentials credentials;

    public OlapBuilderGoogleBigqueryConnection(OlapBuilderGoogleBigqueryDataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected BigQuery buildClient(HttpRequestInitializer initializer, HttpTransport httpTransport, JsonFactory jsonFactory) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public BigQuery getJsonClient() {
        return (BigQuery)super.getJsonClient();
    }

    public BigQuery createJsonClientForDiscover() {
        String projectId = ((OlapBuilderGoogleBigqueryDataSource)this.getDataSource()).getProjectId();
        return (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(this.credentials)).setProjectId(projectId)).build().getService();
    }

    @Override
    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        try {
            IcCubeRequest.assertNotCancelled((String)"add-member");
            this.credentials = this.authorize(context);
            String projectId = ((OlapBuilderGoogleBigqueryDataSource)this.getDataSource()).getCredentialsProjectId();
            this.jsonClient = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(this.credentials)).setProjectId(projectId)).build().getService();
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException((Throwable)ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    @Override
    public String getAccountScope() {
        return "https://www.googleapis.com/auth/bigquery";
    }
}

