/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.bigquery.datasource;

import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableResult;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryBaseDataTable;
import crazydev.iccube.builder.googleapi.bigquery.datasource.OlapBuilderGoogleBigqueryConnection;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapBuilderGoogleBigQueryDataTableRowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderGoogleBigqueryBaseDataTable, OlapBuilderGoogleBigqueryConnection> {
    private int rowsCount;
    private Iterator<FieldValueList> result;
    @Nullable
    private Schema schema;

    public OlapBuilderGoogleBigQueryDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderGoogleBigqueryBaseDataTable table) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)table, table.getName());
    }

    public void doInit() {
        this.initConnection();
        this.rowsCount = 0;
        try {
            Comparable incrLoadMarker = this.context.getIncrementalLoadMarker(this.table);
            TableResult tableResult = ((OlapBuilderGoogleBigqueryBaseDataTable)this.table).executeQuery((OlapBuilderGoogleBigqueryConnection)this.connection, this.maxRowCount, (OlapBuilderGoogleBigqueryBaseDataTable)this.table, incrLoadMarker);
            this.schema = tableResult.getSchema();
            this.result = tableResult.iterateAll().iterator();
        }
        catch (GoogleJsonResponseException ex) {
            throw OlapGoogleApiError.error("Table", this.getTableName(), ex);
        }
        catch (TokenResponseException ex) {
            throw OlapGoogleApiError.error("Table", this.getTableName(), ex);
        }
        catch (IOException | InterruptedException ex) {
            throw new OlapBuilderErrorException(true, OlapGoogleApiError.IO_ERROR, new Serializable[]{ex.getLocalizedMessage(), ""});
        }
    }

    public boolean isRowSafe() {
        return false;
    }

    public IOlapBuilderTableRow doNextRow() {
        if (this.maxRowCount != -1 && this.rowsCount >= this.maxRowCount) {
            return null;
        }
        if (!this.result.hasNext()) {
            return null;
        }
        ++this.rowsCount;
        final FieldValueList row = this.result.next();
        if (this.schema != null) {
            return new OlapBuilderAbstractTableRow(this){
                final /* synthetic */ OlapBuilderGoogleBigQueryDataTableRowReader this$0;
                {
                    OlapBuilderGoogleBigQueryDataTableRowReader olapBuilderGoogleBigQueryDataTableRowReader = this$0;
                    Objects.requireNonNull(olapBuilderGoogleBigQueryDataTableRowReader);
                    this.this$0 = olapBuilderGoogleBigQueryDataTableRowReader;
                }

                @Nullable
                protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                    FieldValue value = row.get(columnDef.getName());
                    if (value.isNull()) {
                        return null;
                    }
                    Field fieldDef = this.this$0.schema.getFields().get(columnDef.getName());
                    switch (fieldDef.getType().getStandardType()) {
                        case BOOL: {
                            return value.getBooleanValue();
                        }
                        case INT64: {
                            return value.getLongValue();
                        }
                        case NUMERIC: 
                        case FLOAT64: {
                            return value.getDoubleValue();
                        }
                        case GEOGRAPHY: 
                        case STRING: {
                            return value.getStringValue();
                        }
                        case TIMESTAMP: {
                            return this.this$0.toJodaTimeStamp(value);
                        }
                        case DATETIME: {
                            return new LocalDateTime(value.getValue());
                        }
                        case DATE: {
                            return new LocalDate(value.getValue());
                        }
                        case TIME: {
                            LocalTime time = LocalTime.parse(value.getStringValue());
                            return time.toNanoOfDay() / 1000L;
                        }
                    }
                    return this.this$0.toComparable(value);
                }
            };
        }
        return new OlapBuilderAbstractTableRow(this){
            final /* synthetic */ OlapBuilderGoogleBigQueryDataTableRowReader this$0;
            {
                OlapBuilderGoogleBigQueryDataTableRowReader olapBuilderGoogleBigQueryDataTableRowReader = this$0;
                Objects.requireNonNull(olapBuilderGoogleBigQueryDataTableRowReader);
                this.this$0 = olapBuilderGoogleBigQueryDataTableRowReader;
            }

            @Nullable
            protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                FieldValue value = row.get(columnDef.getName());
                if (value.isNull()) {
                    return null;
                }
                switch (columnDef.getType()) {
                    case DATE: {
                        return this.this$0.toJodaDate(value);
                    }
                    case DATETIME: {
                        return this.this$0.toJodaDateTime(value);
                    }
                }
                return this.this$0.toComparable(value);
            }
        };
    }

    public Comparable toComparable(FieldValue fieldValue) {
        Object value = fieldValue.getValue();
        return value instanceof Comparable ? (Comparable)value : null;
    }

    private LocalDateTime toJodaTimeStamp(FieldValue value) {
        long epoch = value.getTimestampValue() / 1000L;
        return new LocalDateTime((Object)new Date(epoch), DateTimeZone.UTC);
    }

    private LocalDate toJodaDate(FieldValue value) {
        try {
            long epoch = value.getTimestampValue() / 1000L;
            return new LocalDate((Object)new Date(epoch), DateTimeZone.UTC);
        }
        catch (NumberFormatException ex) {
            return new LocalDate(value.getValue());
        }
    }

    private LocalDateTime toJodaDateTime(FieldValue value) {
        try {
            return this.toJodaTimeStamp(value);
        }
        catch (NumberFormatException ex) {
            return new LocalDateTime(value.getValue());
        }
    }

    public void done() {
        super.done();
    }
}

