/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.types;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdAbstractEnum;
import crazydev.common.lang.CdXmlaSchemaType;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class XmlaTypeConverter {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static String toString(CdXmlaSchemaType type, Object value) {
        if (type != CdXmlaSchemaType.DBTYPE_WSTR) {
            if (value instanceof CdAbstractEnum) {
                return Integer.toString(((CdAbstractEnum)value).getPosition());
            }
            if (value.getClass().isEnum()) {
                return Integer.toString(((Enum)value).ordinal());
            }
        }
        if (type == CdXmlaSchemaType.DBTYPE_DBTIMESTAMP) {
            return DATE_FORMAT.format((Timestamp)value);
        }
        return value.toString();
    }

    @Nullable
    public static Object fromString(CdXmlaSchemaType type, @Nullable String value) {
        if (value == null) {
            return null;
        }
        if (type == CdXmlaSchemaType.DBTYPE_DBTIMESTAMP) {
            try {
                Date date = DATE_FORMAT.parse(value);
                return new Timestamp(date.getTime());
            }
            catch (ParseException ex) {
                throw new CdRuntimeException((Throwable)ex, "unexpected timestamp format [" + value + "]");
            }
        }
        if (type == CdXmlaSchemaType.DBTYPE_BOOL) {
            return Boolean.parseBoolean(value);
        }
        if (type.isNumeric()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                throw new CdRuntimeException((Throwable)ex, "unexpected numeric value format [" + value + "]");
            }
        }
        if (type == CdXmlaSchemaType.DBTYPE_VARIANT) {
            return value;
        }
        throw new CdProgrammingException("unsupported [" + String.valueOf(type) + "]");
    }
}

