/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.execute;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.soap.CdSoapEnvelope;
import crazydev.common.utils.CdStringUtils;
import crazydev.xmla.model.message.XmlaParameter;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQueryParser;
import crazydev.xmla.model.message.execute.XmlaApplyPermissionsStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaCancelCommandQuery;
import crazydev.xmla.model.message.execute.XmlaCommandArguments;
import crazydev.xmla.model.message.execute.XmlaDeleteSchemaBackupStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaDmvStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaFullLoadSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaBackupStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaExStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaPartitionStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadMeasureGroupStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadPartitionsStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadSchemaFromXmlStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaLoadTablePartitionsParams;
import crazydev.xmla.model.message.execute.XmlaMdxStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaPerformGcStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaRefreshCubeStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaReloadSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaRestoreSchemaStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaSchemaManagementStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaUnloadPartitionsStatementCommandQuery;
import crazydev.xmla.model.message.execute.XmlaUnloadSchemaStatementCommandQuery;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlaExecuteQueryParser
extends XmlaQueryParser {
    @Override
    public XmlaExecuteQuery parse(String requestUuid, CdSoapEnvelope soapEnvelope) throws SOAPException {
        String sessionId = XmlaExecuteQueryParser.getSessionId(soapEnvelope);
        SOAPMessage soapMessage = soapEnvelope.getMessage();
        SOAPBody body = soapMessage.getSOAPBody();
        Document dom = body.extractContentAsDocument();
        Element execute = dom.getDocumentElement();
        String executeNS = "urn:schemas-microsoft-com:xml-analysis";
        NodeList statementNodes = execute.getElementsByTagNameNS("urn:schemas-microsoft-com:xml-analysis", "Statement");
        if (statementNodes.getLength() > 0) {
            Node item0 = statementNodes.item(0);
            String statement = item0.getTextContent();
            List<XmlaProperty> properties = XmlaExecuteQueryParser.getProperties(execute, "urn:schemas-microsoft-com:xml-analysis");
            List<XmlaParameter> parameters = XmlaExecuteQueryParser.getParameters(execute, "urn:schemas-microsoft-com:xml-analysis");
            return this.parseStatementRequest(requestUuid, sessionId, statement, properties, parameters);
        }
        String cancelNS = "http://schemas.microsoft.com/analysisservices/2003/engine";
        NodeList cancelNodes = execute.getElementsByTagNameNS("http://schemas.microsoft.com/analysisservices/2003/engine", "Cancel");
        if (cancelNodes.getLength() > 0) {
            List<XmlaProperty> properties = XmlaExecuteQueryParser.getProperties(execute, "urn:schemas-microsoft-com:xml-analysis");
            return new XmlaCancelCommandQuery(requestUuid, sessionId, properties);
        }
        throw new CdRuntimeException("Unrecognized XMLA Execute request!");
    }

    private XmlaExecuteQuery parseStatementRequest(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties, List<XmlaParameter> parameters) {
        String refreshCubeName = this.isRefreshCubeStatement(requestUuid, sessionId, statement = statement.trim(), properties);
        if (refreshCubeName != null) {
            return new XmlaRefreshCubeStatementCommandQuery(requestUuid, sessionId, statement, refreshCubeName, properties);
        }
        String statementU = statement.toUpperCase();
        if (statementU.equals("GC".toUpperCase())) {
            return new XmlaPerformGcStatementCommandQuery(requestUuid, sessionId, statement, properties);
        }
        if (statementU.equals("APPLY_PERMISSIONS".toUpperCase())) {
            return new XmlaApplyPermissionsStatementCommandQuery(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("UNLOAD_PARTITIONS".toUpperCase())) {
            return this.parseDeletePartitionsCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LOAD_PARTITIONS".toUpperCase())) {
            return this.parseLoadPartitionsCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LOAD_MEASURE_GROUP".toUpperCase())) {
            return this.parseLoadMeasureGroupCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LOAD_SCHEMA_FROM_XML".toUpperCase())) {
            return this.parseLoadSchemaFromXmlCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LOAD_SCHEMA".toUpperCase())) {
            return this.parseLoadSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("FULL_LOAD_SCHEMA".toUpperCase())) {
            return this.parseFullLoadSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("RELOAD_SCHEMA".toUpperCase())) {
            return this.parseReloadSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("UNLOAD_SCHEMA".toUpperCase())) {
            return this.parseUnloadSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("RESTORE_SCHEMA".toUpperCase())) {
            return this.parseRestoreSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LIST_SCHEMA_PARTITION".toUpperCase())) {
            return this.parseListSchemaPartitionCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LIST_SCHEMA_BACKUP".toUpperCase())) {
            return this.parseListSchemaBackupCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LIST_SCHEMA_EX".toUpperCase())) {
            return this.parseListSchemaExCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("LIST_SCHEMA".toUpperCase())) {
            return this.parseListSchemaCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.startsWith("DELETE_SCHEMA_BACKUP".toUpperCase())) {
            return this.parseDeleteSchemaBackupCommand(requestUuid, sessionId, statement, properties);
        }
        if (statementU.contains("$SYSTEM.")) {
            return new XmlaDmvStatementCommandQuery(requestUuid, sessionId, statement, properties, parameters);
        }
        return new XmlaMdxStatementCommandQuery(requestUuid, sessionId, statement, properties, parameters);
    }

    @Nullable
    private String isRefreshCubeStatement(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String mdx = statement.toLowerCase();
        if (mdx.startsWith("refresh") && !(mdx = mdx.substring("refresh".length())).startsWith("cube") && (mdx = mdx.trim()).startsWith("cube")) {
            if (CdStringUtils.isNullOrBlank((String)(mdx = mdx.substring("cube".length())))) {
                return "";
            }
            return mdx;
        }
        return null;
    }

    private XmlaExecuteQuery parseDeletePartitionsCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        Integer cancelS;
        XmlaCommandArguments arguments = new XmlaCommandArguments("UNLOAD_PARTITIONS", statement);
        int schemaPos = 0;
        Integer waitS = arguments.getByNameOptionalInt("waitS");
        if (waitS != null) {
            ++schemaPos;
        }
        if ((cancelS = arguments.getByNameOptionalInt("cancelS")) != null) {
            // empty if block
        }
        int n = ++schemaPos;
        String schema = arguments.get("schema", n);
        int n2 = ++schemaPos;
        String dataSourceName = arguments.get("datasource", n2);
        int n3 = ++schemaPos;
        String dataTableName = arguments.get("datatable", n3);
        int n4 = ++schemaPos;
        ++schemaPos;
        List<String> partitions = arguments.getAsList("partitions", n4);
        boolean partitionsAsRange = arguments.isRange();
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        return new XmlaUnloadPartitionsStatementCommandQuery(requestUuid, sessionId, statement, schema, dataSourceName, dataTableName, partitionsAsRange, partitions, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1, properties);
    }

    private static void mergeTablePartitions(XmlaLoadTablePartitionsParams params, boolean asRange, List<String> partitions) {
        if (asRange != params.partitionsAsRange) {
            throw new CdRuntimeException("LOAD_PARTITIONS error: unexpected partition range for table [" + params.tableName + "]");
        }
        HashSet<String> existingPartitions = new HashSet<String>(params.partitions);
        for (String partition : partitions) {
            if (existingPartitions.contains(partition)) continue;
            params.partitions.add(partition);
        }
        if (asRange && partitions.size() != 2) {
            throw new CdRuntimeException("LOAD_PARTITIONS error: unexpected partition count for table [" + params.tableName + "]");
        }
    }

    public static List<XmlaLoadTablePartitionsParams> extractTablesPartitions(List<String> tokens) {
        ArrayList<String> tableNames = new ArrayList<String>();
        HashMap<String, XmlaLoadTablePartitionsParams> params = new HashMap<String, XmlaLoadTablePartitionsParams>();
        String table = null;
        boolean asRange = false;
        ArrayList<String> partitions = null;
        for (String token : tokens) {
            if (table == null) {
                if (token.equals(":") || token.equals("and")) {
                    throw new CdRuntimeException("LOAD_PARTITIONS error: table name expected [actual:" + token + "]");
                }
                table = token;
                asRange = false;
                partitions = new ArrayList<String>();
                continue;
            }
            if (token.equals(":")) {
                if (asRange) {
                    throw new CdRuntimeException("LOAD_PARTITIONS error: duplicated partition range for table [" + table + "]");
                }
                asRange = true;
                continue;
            }
            if (token.equals("and")) {
                XmlaLoadTablePartitionsParams existing = (XmlaLoadTablePartitionsParams)params.get(table);
                if (existing == null) {
                    params.put(table, new XmlaLoadTablePartitionsParams(table, asRange, partitions));
                    tableNames.add(table);
                } else {
                    XmlaExecuteQueryParser.mergeTablePartitions(existing, asRange, partitions);
                }
                table = null;
                asRange = false;
                partitions = null;
                continue;
            }
            partitions.add(token);
        }
        if (table != null) {
            if (partitions.isEmpty()) {
                throw new CdRuntimeException("LOAD_PARTITIONS error: no partition for table [" + table + "]");
            }
            if (asRange && partitions.size() != 2) {
                throw new CdRuntimeException("LOAD_PARTITIONS error: unexpected partition count for table [" + table + "]");
            }
            XmlaLoadTablePartitionsParams existing = (XmlaLoadTablePartitionsParams)params.get(table);
            if (existing == null) {
                params.put(table, new XmlaLoadTablePartitionsParams(table, asRange, partitions));
                tableNames.add(table);
            } else {
                XmlaExecuteQueryParser.mergeTablePartitions(existing, asRange, (List<String>)partitions);
            }
        }
        if (params.isEmpty()) {
            throw new CdRuntimeException("LOAD_PARTITIONS error: no partition");
        }
        ArrayList<XmlaLoadTablePartitionsParams> tParams = new ArrayList<XmlaLoadTablePartitionsParams>();
        for (String tableName : tableNames) {
            tParams.add((XmlaLoadTablePartitionsParams)params.get(tableName));
        }
        return tParams;
    }

    private XmlaExecuteQuery parseLoadPartitionsCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        Integer cancelS;
        Integer waitS;
        XmlaCommandArguments arguments = XmlaCommandArguments.createForLoadPartitions("LOAD_PARTITIONS", statement);
        int schemaPos = 0;
        boolean continueBackupOnError = arguments.hasByName("continueBackupOnError");
        if (continueBackupOnError) {
            ++schemaPos;
        }
        if ((waitS = arguments.getByNameOptionalInt("waitS")) != null) {
            ++schemaPos;
        }
        if ((cancelS = arguments.getByNameOptionalInt("cancelS")) != null) {
            // empty if block
        }
        int n = ++schemaPos;
        String schema = arguments.get("schema", n);
        int n2 = ++schemaPos;
        String dataSourceName = arguments.get("datasource", n2);
        int n3 = ++schemaPos;
        ++schemaPos;
        List<XmlaLoadTablePartitionsParams> partitions = XmlaExecuteQueryParser.extractTablesPartitions(arguments.getAsList("partitions", n3));
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        return new XmlaLoadPartitionsStatementCommandQuery(requestUuid, sessionId, statement, schema, dataSourceName, partitions, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1, continueBackupOnError, properties);
    }

    private XmlaExecuteQuery parseLoadMeasureGroupCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        Integer cancelS;
        XmlaCommandArguments arguments = new XmlaCommandArguments("LOAD_MEASURE_GROUP", statement);
        int schemaPos = 0;
        Integer waitS = arguments.getByNameOptionalInt("waitS");
        if (waitS != null) {
            ++schemaPos;
        }
        if ((cancelS = arguments.getByNameOptionalInt("cancelS")) != null) {
            // empty if block
        }
        int n = ++schemaPos;
        String schema = arguments.get("schema", n);
        int n2 = ++schemaPos;
        String cube = arguments.get("cube", n2);
        String measureGroup = arguments.size() > ++schemaPos ? arguments.get("measureGroup", schemaPos) : null;
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        return new XmlaLoadMeasureGroupStatementCommandQuery(requestUuid, sessionId, statement, schema, cube, measureGroup, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1, properties);
    }

    private XmlaExecuteQuery parseLoadSchemaFromXmlCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "LOAD_SCHEMA_FROM_XML";
        LoadFromXmlParams params = this.parseLoadFromXmlParams(requestUuid, sessionId, statement, properties, "LOAD_SCHEMA_FROM_XML");
        return new XmlaLoadSchemaFromXmlStatementCommandQuery(requestUuid, sessionId, statement, params.schemaName, params.schemaFactoryDefinition, params.writeTo, properties);
    }

    private XmlaExecuteQuery parseLoadSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "LOAD_SCHEMA";
        LoadParams params = this.parseLoadParams(requestUuid, sessionId, statement, properties, "LOAD_SCHEMA", false);
        return new XmlaLoadSchemaStatementCommandQuery(requestUuid, sessionId, statement, params.schemaName, params.schemaFactoryFileName, params.keepMdxResultCache, params.waitS, params.cancelS, properties);
    }

    private XmlaExecuteQuery parseFullLoadSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "FULL_LOAD_SCHEMA";
        LoadParams params = this.parseLoadParams(requestUuid, sessionId, statement, properties, "FULL_LOAD_SCHEMA", true);
        return new XmlaFullLoadSchemaStatementCommandQuery(requestUuid, sessionId, statement, params.offlineMode, params.offlineSnapshot, params.schemaName, params.schemaFactoryFileName, params.forceBackupOn, params.waitS, params.cancelS, properties);
    }

    private XmlaExecuteQuery parseReloadSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "RELOAD_SCHEMA";
        LoadParams params = this.parseLoadParams(requestUuid, sessionId, statement, properties, "RELOAD_SCHEMA", false);
        return new XmlaReloadSchemaStatementCommandQuery(requestUuid, sessionId, statement, params.schemaName, params.schemaFactoryFileName, params.waitS, params.cancelS, properties);
    }

    private XmlaExecuteQuery parseUnloadSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        Integer cancelS;
        XmlaCommandArguments arguments = new XmlaCommandArguments("UNLOAD_SCHEMA", statement);
        int schemaPos = 0;
        Integer waitS = arguments.getByNameOptionalInt("waitS");
        if (waitS != null) {
            ++schemaPos;
        }
        if ((cancelS = arguments.getByNameOptionalInt("cancelS")) != null) {
            ++schemaPos;
        }
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        String schema = arguments.get("schema", schemaPos);
        return new XmlaUnloadSchemaStatementCommandQuery(requestUuid, sessionId, statement, schema, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1, properties);
    }

    private XmlaExecuteQuery parseRestoreSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        Integer cancelS;
        XmlaCommandArguments arguments = new XmlaCommandArguments("RESTORE_SCHEMA", statement);
        int schemaPos = 0;
        Integer waitS = arguments.getByNameOptionalInt("waitS");
        if (waitS != null) {
            ++schemaPos;
        }
        if ((cancelS = arguments.getByNameOptionalInt("cancelS")) != null) {
            // empty if block
        }
        int n = ++schemaPos;
        String schema = arguments.get("schema", n);
        int n2 = ++schemaPos;
        String timestamp = arguments.get("timestamp", n2);
        String mode = arguments.size() > ++schemaPos ? arguments.get("mode", schemaPos) : null;
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        return new XmlaRestoreSchemaStatementCommandQuery(requestUuid, sessionId, statement, schema, timestamp, mode, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1, properties);
    }

    private XmlaExecuteQuery parseListSchemaCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        XmlaCommandArguments arguments = new XmlaCommandArguments("LIST_SCHEMA", statement);
        String schema = null;
        if (arguments.size() > 0) {
            schema = arguments.get("schema", 0);
        }
        return new XmlaListSchemaStatementCommandQuery(requestUuid, sessionId, statement, schema, properties);
    }

    private XmlaExecuteQuery parseListSchemaExCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        return new XmlaListSchemaExStatementCommandQuery(requestUuid, sessionId, statement, properties);
    }

    private XmlaExecuteQuery parseListSchemaPartitionCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "LIST_SCHEMA_PARTITION";
        XmlaCommandArguments arguments = new XmlaCommandArguments("LIST_SCHEMA_PARTITION", statement);
        String schema = null;
        if (arguments.size() > 0) {
            schema = arguments.get("schema", 0);
        }
        if (CdStringUtils.isNullOrBlank(schema)) {
            throw new CdRuntimeException("Missing LIST_SCHEMA_PARTITION schema parameter");
        }
        return new XmlaListSchemaPartitionStatementCommandQuery(requestUuid, sessionId, statement, schema, properties);
    }

    private XmlaExecuteQuery parseListSchemaBackupCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        XmlaCommandArguments arguments = new XmlaCommandArguments("LIST_SCHEMA_BACKUP", statement);
        String schema = null;
        if (arguments.size() > 0) {
            schema = arguments.get("schema", 0);
        }
        return new XmlaListSchemaBackupStatementCommandQuery(requestUuid, sessionId, statement, schema, properties);
    }

    private XmlaExecuteQuery parseDeleteSchemaBackupCommand(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties) {
        String commandName = "DELETE_SCHEMA_BACKUP";
        XmlaCommandArguments arguments = new XmlaCommandArguments("DELETE_SCHEMA_BACKUP", statement);
        String schema = null;
        if (arguments.size() > 0) {
            schema = arguments.get("schema", 0);
        }
        if (CdStringUtils.isNullOrBlank(schema)) {
            throw new CdRuntimeException("Missing DELETE_SCHEMA_BACKUP schema parameter");
        }
        String timestamp = null;
        if (arguments.size() > 1) {
            timestamp = arguments.get("timestamp", 1);
        }
        if (CdStringUtils.isNullOrBlank(timestamp)) {
            throw new CdRuntimeException("Missing DELETE_SCHEMA_BACKUP timestamp parameter");
        }
        return new XmlaDeleteSchemaBackupStatementCommandQuery(requestUuid, sessionId, statement, schema, timestamp, properties);
    }

    private LoadParams parseLoadParams(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties, String commandName, boolean fullLoad) {
        XmlaCommandArguments arguments = new XmlaCommandArguments(commandName, statement);
        if (arguments.isEmpty()) {
            throw new CdRuntimeException("Missing " + commandName + " parameters");
        }
        int schemaNamePos = 0;
        Integer waitS = null;
        Integer cancelS = null;
        boolean forceBackupOn = false;
        boolean keepMdxResultCache = false;
        XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.OFF;
        String offlineSnapshot = null;
        for (int ii = 0; ii < arguments.size(); ++ii) {
            String[] parts;
            String arg = arguments.get(ii);
            if (arg.toUpperCase().startsWith("OFFLINE:")) {
                if (!fullLoad) {
                    throw new CdRuntimeException("Invalid " + commandName + " offline parameter");
                }
                parts = arg.split(":");
                if (parts.length != 2 || CdStringUtils.isNullOrBlank((String)parts[1])) {
                    throw new CdRuntimeException("Invalid " + commandName + " offline parameter");
                }
                if (parts[1].equals("write")) {
                    offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE;
                    offlineSnapshot = null;
                } else if (parts[1].equals("write-zip")) {
                    offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE_ZIP;
                    offlineSnapshot = null;
                } else if (parts[1].equals("write-only")) {
                    offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.WRITE_ONLY;
                    offlineSnapshot = null;
                } else {
                    offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.READ;
                    offlineSnapshot = parts[1];
                }
                schemaNamePos = ii + 1;
                continue;
            }
            if (arg.toUpperCase().startsWith("WAITS:")) {
                parts = arg.split(":");
                waitS = Integer.parseInt(parts[1]);
                schemaNamePos = ii + 1;
                continue;
            }
            if (arg.toUpperCase().startsWith("CANCELS:")) {
                parts = arg.split(":");
                cancelS = Integer.parseInt(parts[1]);
                schemaNamePos = ii + 1;
                continue;
            }
            if (arg.toUpperCase().equals("KEEPMDXRESULTCACHE")) {
                keepMdxResultCache = true;
                schemaNamePos = ii + 1;
                continue;
            }
            if (!arg.toUpperCase().equals("BACKUP")) continue;
            forceBackupOn = true;
            schemaNamePos = ii + 1;
        }
        String schemaName = null;
        String schemaFactoryFileName = null;
        if (schemaNamePos < arguments.size()) {
            schemaName = arguments.get(schemaNamePos);
            ++schemaNamePos;
        }
        if (schemaNamePos < arguments.size()) {
            schemaFactoryFileName = arguments.get(schemaNamePos);
            ++schemaNamePos;
        }
        if (schemaName == null) {
            throw new CdRuntimeException("Missing " + commandName + " schema-name parameter");
        }
        if (waitS != null && cancelS == null || waitS == null && cancelS != null) {
            throw new CdRuntimeException("Inconsistent waitS and cancelS parameters");
        }
        return new LoadParams(offlineMode, offlineSnapshot, schemaName, schemaFactoryFileName, forceBackupOn, keepMdxResultCache, waitS != null ? waitS : -1, cancelS != null ? cancelS : -1);
    }

    private LoadFromXmlParams parseLoadFromXmlParams(String requestUuid, String sessionId, String statement, List<XmlaProperty> properties, String commandName) {
        String schemaName;
        String arguments = (statement = statement.trim()).substring(commandName.length()).trim();
        if (arguments.isEmpty()) {
            throw new CdRuntimeException("Missing " + commandName + " parameters");
        }
        int xmlStartPos = arguments.indexOf("<?xml");
        if (xmlStartPos == -1) {
            throw new CdRuntimeException("Missing " + commandName + " schema-definition parameter (i.e., <?xml ... )");
        }
        String line = arguments.substring(0, xmlStartPos).trim();
        if (CdStringUtils.isNullOrBlank((String)line)) {
            throw new CdRuntimeException("Missing " + commandName + " schema-name parameter");
        }
        int schemaNamePos = 0;
        String writeTo = null;
        if (line.startsWith("write:")) {
            int pos = -1;
            for (int ii = 0; ii < arguments.length(); ++ii) {
                if (!Character.isSpaceChar(arguments.charAt(ii))) continue;
                pos = ii;
                break;
            }
            if (pos == -1) {
                throw new CdRuntimeException("Missing " + commandName + " write-to-file parameter");
            }
            writeTo = line.substring(6, pos).trim();
            if (CdStringUtils.isNullOrBlank((String)writeTo)) {
                throw new CdRuntimeException("Missing " + commandName + " write: parameter");
            }
            schemaNamePos += pos;
        }
        if (CdStringUtils.isNullOrBlank((String)(schemaName = arguments.substring(schemaNamePos, xmlStartPos).trim()))) {
            throw new CdRuntimeException("Missing " + commandName + " schema-name parameter");
        }
        String schemaFactoryDefinition = arguments.substring(xmlStartPos);
        return new LoadFromXmlParams(schemaName, schemaFactoryDefinition, writeTo);
    }

    private static class LoadFromXmlParams {
        final String schemaName;
        final String schemaFactoryDefinition;
        @Nullable
        final String writeTo;

        private LoadFromXmlParams(String schemaName, String schemaFactoryDefinition, @Nullable String writeTo) {
            this.schemaName = schemaName;
            this.schemaFactoryDefinition = schemaFactoryDefinition;
            this.writeTo = writeTo;
        }
    }

    private static class LoadParams {
        final XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode;
        @Nullable
        final String offlineSnapshot;
        final String schemaName;
        @Nullable
        final String schemaFactoryFileName;
        final boolean forceBackupOn;
        final boolean keepMdxResultCache;
        final int waitS;
        final int cancelS;

        private LoadParams(XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode, @Nullable String offlineSnapshot, String schemaName, @Nullable String schemaFactoryFileName, boolean forceBackupOn, boolean keepMdxResultCache, int waitS, int cancelS) {
            this.offlineMode = offlineMode;
            this.offlineSnapshot = offlineSnapshot;
            this.schemaName = schemaName;
            this.schemaFactoryFileName = schemaFactoryFileName;
            this.forceBackupOn = forceBackupOn;
            this.keepMdxResultCache = keepMdxResultCache;
            this.waitS = waitS;
            this.cancelS = cancelS;
        }
    }
}

