/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.execute;

import crazydev.xmla.model.message.XmlaParameter;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaQueryKind;
import crazydev.xmla.model.message.execute.XmlaStatementCommandQuery;
import crazydev.xmla.model.message.property.XmlaCatalogProperty;
import crazydev.xmla.model.types.XmlaFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class XmlaDmvStatementCommandQuery
extends XmlaStatementCommandQuery {
    private final List<XmlaParameter> parameters;

    public XmlaDmvStatementCommandQuery(String uuid, String sessionId, String statement, List<XmlaProperty> properties, List<XmlaParameter> parameters) {
        super(uuid, sessionId, XmlaDmvStatementCommandQuery.changeParams(statement, parameters), properties);
        this.parameters = parameters;
    }

    private XmlaDmvStatementCommandQuery(XmlaDmvStatementCommandQuery that, @Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newStatement) {
        super(that, newSessionId, newSchemaName, newStatement);
        this.parameters = new ArrayList<XmlaParameter>();
        for (XmlaParameter thatParameter : that.parameters) {
            this.parameters.add(new XmlaParameter(thatParameter));
        }
    }

    private static String changeParams(String statement, List<XmlaParameter> parameters) {
        for (XmlaParameter parameter : parameters) {
            statement = parameter.replace(statement);
        }
        return statement;
    }

    @Override
    public XmlaQuery duplicateForLoadTesting(@Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newSchemaDefinition, @Nullable String newStatement) {
        return new XmlaDmvStatementCommandQuery(this, newSessionId, newSchemaName, newStatement);
    }

    @Override
    protected XmlaFormat getActualFormatForNative() {
        return XmlaFormat.Tabular;
    }

    @Override
    public XmlaQueryKind getKind() {
        return XmlaQueryKind.DMV;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "XMLA Execute DMV";
    }

    @Override
    public void fixMissingCatalog(Supplier<String> firstAuthorizedSchemaName) {
        String initialCatalog;
        String catalog = this.getCatalog();
        if (catalog == null && (initialCatalog = firstAuthorizedSchemaName.get()) != null) {
            this.addProperties(new XmlaCatalogProperty(initialCatalog));
        }
    }
}

