/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.discover;

import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaRestriction;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.message.common.XmlaAbstractQuery;
import crazydev.xmla.model.types.XmlaFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaDiscoverQuery
extends XmlaAbstractQuery {
    private final String requestType;
    private final List<XmlaRestriction> restrictions;

    public XmlaDiscoverQuery(String uuid, @Nullable String sessionId, String requestType, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        super(uuid, sessionId, properties);
        this.requestType = requestType;
        this.restrictions = restrictions;
    }

    private XmlaDiscoverQuery(XmlaDiscoverQuery that, @Nullable String newSessionId, @Nullable String newSchemaName) {
        super(that, newSessionId, newSchemaName);
        this.requestType = that.requestType;
        this.restrictions = new ArrayList<XmlaRestriction>();
        for (XmlaRestriction thatRestriction : that.restrictions) {
            this.restrictions.add(new XmlaRestriction(thatRestriction.getName(), thatRestriction.getValue()));
        }
    }

    @Override
    public XmlaQuery duplicateForLoadTesting(@Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newSchemaDefinition, @Nullable String newStatement) {
        return new XmlaDiscoverQuery(this, newSessionId, newSchemaName);
    }

    @Override
    protected XmlaFormat getActualFormatForNative() {
        return XmlaFormat.Tabular;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "XMLA Discover ( " + this.requestType + " )";
    }

    @Override
    public boolean isDiscover() {
        return true;
    }

    @Override
    public boolean isMonitored() {
        return true;
    }

    @Override
    public String getSoapAction() {
        return "\"urn:schemas-microsoft-com:xml-analysis:Discover\"";
    }

    public String getRequestType() {
        return this.requestType;
    }

    public List<XmlaRestriction> getRestrictions() {
        return this.restrictions;
    }

    @Override
    protected void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
        serializer.startElement(null, null, "Discover", attrs);
        serializer.addElement("RequestType", this.requestType);
        this.doEmitSoapRestrictions(serializer);
        this.doEmitSoapProperties(serializer);
        serializer.endElement(null, null, "Discover");
    }

    protected void doEmitSoapRestrictions(XmlaSerializer serializer) throws SAXException {
        serializer.startElement(null, null, "Restrictions", null);
        if (!this.restrictions.isEmpty()) {
            serializer.startElement(null, null, "RestrictionList", null);
            for (XmlaRestriction restriction : this.restrictions) {
                serializer.addElement(restriction.getName(), restriction.toXmlaString());
            }
            serializer.endElement(null, null, "RestrictionList");
        }
        serializer.endElement(null, null, "Restrictions");
    }
}

