/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.authenticate;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.types.XmlaFormat;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaAuthenticateQuery
extends XmlaQuery {
    private final String token;

    public XmlaAuthenticateQuery(String uuid, String token) {
        super(uuid);
        this.token = token;
    }

    private XmlaAuthenticateQuery(XmlaAuthenticateQuery that, @Nullable String newSessionId, @Nullable String newSchemaName) {
        super(that, newSessionId, newSchemaName);
        this.token = that.token;
    }

    @Override
    public XmlaQuery duplicateForLoadTesting(@Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newSchemaDefinition, @Nullable String newStatement) {
        return new XmlaAuthenticateQuery(this, newSessionId, newSchemaName);
    }

    @Override
    protected XmlaFormat getActualFormatForNative() {
        return XmlaFormat.Tabular;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "XMLA Authenticate";
    }

    @Override
    public String getSoapAction() {
        throw new CdProgrammingException();
    }

    public String getToken() {
        return this.token;
    }

    @Override
    protected void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, null, "xmlns", "string", "http://schemas.microsoft.com/analysisservices/2003/ext");
        serializer.startElement(null, null, "Authenticate", attrs);
        serializer.startElement(null, null, "SspiHandshake", new AttributesImpl());
        serializer.characters(this.token.toCharArray(), 0, this.token.length());
        serializer.endElement(null, null, "SspiHandshake");
        serializer.endElement(null, null, "Authenticate");
    }
}

