/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.xmla.model.annotation.XmlaAnCardinality;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XML11Serializer;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaSerializer
extends XML11Serializer {
    private final CdXmlaCaller caller;
    @Nullable
    private final OutputStream out;
    private final PrintWriter writer;

    public XmlaSerializer(CdXmlaCaller caller, @Nullable OutputStream out, PrintWriter writer, OutputFormat format) {
        super((Writer)writer, format);
        this.caller = caller;
        this.out = out;
        this.writer = writer;
    }

    public static String toXsdString(CdXmlaSchemaType type) {
        if (type == CdXmlaSchemaType.DBTYPE_GUID) {
            return type.getSerializingName();
        }
        if (type == CdXmlaSchemaType.DBTYPE_XML) {
            return type.getSerializingName();
        }
        return "xsd:" + type.getSerializingName();
    }

    public CdXmlaCaller getXmlaCaller() {
        return this.caller;
    }

    public void addElement(String element, String content) throws SAXException {
        this.startElement(null, null, element, null);
        char[] xvalue = content.toCharArray();
        this.characters(xvalue, 0, xvalue.length);
        this.endElement(null, null, element);
    }

    public void addXmlaSchemaElement(String element, String name, @Nullable CdXmlaSchemaType type) throws SAXException {
        this.addXmlaSchemaElement(element, name, type, null, false);
    }

    public void addXmlaSchemaElement(String element, String name, @Nullable CdXmlaSchemaType type, @Nullable XmlaAnCardinality cardinality, boolean includeSqlField) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (includeSqlField) {
            attrs.addAttribute(null, null, "sql:field", "string", name);
        }
        attrs.addAttribute(null, null, "name", "string", name);
        if (type != null && !type.equals((Object)CdXmlaSchemaType.DBTYPE_VARIANT)) {
            attrs.addAttribute(null, null, "type", "string", XmlaSerializer.toXsdString(type));
        }
        if (cardinality == XmlaAnCardinality.ZERO_OR_ONE) {
            attrs.addAttribute(null, null, "minOccurs", "string", "0");
        }
        if (cardinality == XmlaAnCardinality.UNBOUND) {
            attrs.addAttribute(null, null, "minOccurs", "string", "0");
            attrs.addAttribute(null, null, "maxOccurs", "string", "unbounded");
        }
        this.startElement(null, null, element, attrs);
        this.endElement(null, null, element);
    }

    public void addRawXml(String xml) throws IOException {
        this.content();
        this._printer.flush();
        this.writer.println(xml);
        this.writer.flush();
    }

    public OutputStream asOutputStream() throws IOException {
        if (this.out == null) {
            throw new RuntimeException("internal error : inconsistent usage of XMLA serializer output stream");
        }
        this.content();
        this._printer.flush();
        return this.out;
    }
}

