/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.soap.CdSoapEnvelope;
import crazydev.common.utils.CdStringUtils;
import crazydev.xmla.model.message.XmlaParameter;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaPropertyParser;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaRestriction;
import crazydev.xmla.model.message.authenticate.XmlaAuthenticateQueryParser;
import crazydev.xmla.model.message.discover.XmlaDiscoverQuery;
import crazydev.xmla.model.message.discover.XmlaDiscoverQueryParser;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaExecuteQueryParser;
import crazydev.xmla.model.message.execute.XmlaStatementCommandQuery;
import crazydev.xmla.model.message.session.XmlaBeginGetSessionTokenQueryParser;
import crazydev.xmla.model.message.session.XmlaBeginSessionQuery;
import crazydev.xmla.model.message.session.XmlaBeginSessionQueryParser;
import crazydev.xmla.model.message.session.XmlaEndSessionQuery;
import crazydev.xmla.model.message.session.XmlaEndSessionQueryParser;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlaQueryParser {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.xmla.request");

    protected XmlaQueryParser() {
    }

    public static XmlaQuery parseSoapEnvelope(String requestUuid, CdSoapEnvelope soapEnvelope) throws SOAPException {
        SOAPBody body;
        SOAPMessage soapMessage = soapEnvelope.getMessage();
        SOAPHeader header = soapMessage.getSOAPHeader();
        if (header != null) {
            Iterator headerElements = header.examineAllHeaderElements();
            while (headerElements.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)headerElements.next();
                String name = headerElement.getElementName().getLocalName();
                if ("BeginSession".equals(name)) {
                    XmlaBeginSessionQuery beginSessionQuery = new XmlaBeginSessionQueryParser().parse(requestUuid, soapEnvelope);
                    XmlaQuery discoverOrExecuteQuery = XmlaQueryParser.parseOptionalDiscoverOrExecute(requestUuid, soapEnvelope, soapMessage);
                    if (discoverOrExecuteQuery != null) {
                        discoverOrExecuteQuery.attachBeginSessionHeader();
                        return discoverOrExecuteQuery;
                    }
                    return beginSessionQuery;
                }
                if ("EndSession".equals(name)) {
                    XmlaEndSessionQuery endSessionQuery = new XmlaEndSessionQueryParser().parse(requestUuid, soapEnvelope);
                    XmlaQuery discoverOrExecuteQuery = XmlaQueryParser.parseOptionalDiscoverOrExecute(requestUuid, soapEnvelope, soapMessage);
                    if (discoverOrExecuteQuery != null) {
                        discoverOrExecuteQuery.attachEndSessionHeader();
                        return discoverOrExecuteQuery;
                    }
                    return endSessionQuery;
                }
                if (!"BeginGetSessionToken".equals(name)) continue;
                return new XmlaBeginGetSessionTokenQueryParser().parse(requestUuid, soapEnvelope);
            }
        }
        if ((body = soapMessage.getSOAPBody()).getElementsByTagName("Authenticate").getLength() > 0) {
            return new XmlaAuthenticateQueryParser().parse(requestUuid, soapEnvelope);
        }
        if (body.getElementsByTagName("Discover").getLength() > 0) {
            return new XmlaDiscoverQueryParser().parse(requestUuid, soapEnvelope);
        }
        if (body.getElementsByTagName("Execute").getLength() > 0) {
            return new XmlaExecuteQueryParser().parse(requestUuid, soapEnvelope);
        }
        LOGGER.info((Object)("Unsupported XMLA message:\n" + soapEnvelope.toString()));
        throw new CdRuntimeException("Unsupported XMLA message!");
    }

    @Nullable
    private static XmlaQuery parseOptionalDiscoverOrExecute(String requestUuid, CdSoapEnvelope soapEnvelope, SOAPMessage soapMessage) throws SOAPException {
        XmlaStatementCommandQuery statementQuery;
        String statement;
        XmlaExecuteQuery query;
        SOAPBody body = soapMessage.getSOAPBody();
        if (body.getElementsByTagName("Discover").getLength() > 0) {
            XmlaDiscoverQuery query2 = new XmlaDiscoverQueryParser().parse(requestUuid, soapEnvelope);
            return query2;
        }
        if (body.getElementsByTagName("Execute").getLength() > 0 && (query = new XmlaExecuteQueryParser().parse(requestUuid, soapEnvelope)) instanceof XmlaStatementCommandQuery && CdStringUtils.isNotNullAndNotBlank((String)(statement = (statementQuery = (XmlaStatementCommandQuery)query).getStatement()))) {
            return statementQuery;
        }
        return null;
    }

    @Nullable
    public static String getSessionId(CdSoapEnvelope envelope) throws SOAPException {
        String sessionId = null;
        SOAPMessage message = envelope.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        if (header != null) {
            Iterator helements = header.examineAllHeaderElements();
            while (helements.hasNext()) {
                SOAPHeaderElement helement = (SOAPHeaderElement)helements.next();
                String name = helement.getElementName().getLocalName();
                if (!"Session".equals(name) && !"EndSession".equals(name)) continue;
                Iterator anames = helement.getAllAttributes();
                while (anames.hasNext()) {
                    Name aname = (Name)anames.next();
                    String lname = aname.getLocalName();
                    if (!"SessionId".equals(lname)) continue;
                    sessionId = helement.getAttributeValue(aname);
                }
            }
        }
        return sessionId;
    }

    protected static List<XmlaProperty> getProperties(Element root, String rootNS) {
        ArrayList<XmlaProperty> properties = new ArrayList<XmlaProperty>();
        Node propertyListNode = root.getElementsByTagNameNS(rootNS, "PropertyList").item(0);
        if (propertyListNode != null) {
            NodeList propertyNodes = propertyListNode.getChildNodes();
            int len = propertyNodes.getLength();
            for (int idx = 0; idx < len; ++idx) {
                Node node = propertyNodes.item(idx);
                if (!(node instanceof Element)) continue;
                String name = node.getLocalName();
                String value = node.getTextContent();
                XmlaProperty property = XmlaPropertyParser.parseProperty(name, value);
                properties.add(property);
            }
        }
        return properties;
    }

    protected static List<XmlaRestriction> getRestrictions(Element root, String rootNS) {
        ArrayList<XmlaRestriction> restrictions = new ArrayList<XmlaRestriction>();
        Node restrictionListNode = root.getElementsByTagNameNS(rootNS, "RestrictionList").item(0);
        if (restrictionListNode != null) {
            NodeList restrictionNodes = restrictionListNode.getChildNodes();
            int len = restrictionNodes.getLength();
            for (int idx = 0; idx < len; ++idx) {
                NodeList children;
                int childrenLen;
                Node node = restrictionNodes.item(idx);
                if (!(node instanceof Element)) continue;
                String name = node.getLocalName();
                String value = node.getTextContent();
                if (name.equals("PropertyName") && (childrenLen = (children = node.getChildNodes()).getLength()) > 1) {
                    for (int cc = 0; cc < childrenLen; ++cc) {
                        Node cNode = children.item(cc);
                        if (!(cNode instanceof Element)) continue;
                        String cName = cNode.getLocalName();
                        String cValue = cNode.getTextContent();
                        restrictions.add(new XmlaRestriction(name, cValue));
                    }
                    continue;
                }
                restrictions.add(new XmlaRestriction(name, value));
            }
        }
        return restrictions;
    }

    protected static List<XmlaParameter> getParameters(Element root, String rootNS) {
        ArrayList<XmlaParameter> parameters = new ArrayList<XmlaParameter>();
        Node restrictionListNode = root.getElementsByTagNameNS(rootNS, "Parameters").item(0);
        if (restrictionListNode != null) {
            NodeList restrictionNodes = restrictionListNode.getChildNodes();
            int len = restrictionNodes.getLength();
            for (int idx = 0; idx < len; ++idx) {
                Node node = restrictionNodes.item(idx);
                if (!(node instanceof Element)) continue;
                Node nameNode = ((Element)node).getElementsByTagName("Name").item(0);
                Node valueNode = ((Element)node).getElementsByTagName("Value").item(0);
                String name = nameNode.getTextContent();
                String value = valueNode.getTextContent();
                Node type = valueNode.getAttributes().getNamedItem("xsi:type");
                parameters.add(new XmlaParameter(name, value, type == null ? null : type.getTextContent()));
            }
        }
        return parameters;
    }

    public abstract XmlaQuery parse(String var1, CdSoapEnvelope var2) throws SOAPException;
}

