/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.xmla.model.common.XmlaConstants;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQueryKind;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.message.property.XmlaCatalogProperty;
import crazydev.xmla.model.message.property.XmlaExecutionModeProperty;
import crazydev.xmla.model.message.property.XmlaFormatProperty;
import crazydev.xmla.model.message.property.XmlaLocaleIdentifierProperty;
import crazydev.xmla.model.types.XmlaExecutionMode;
import crazydev.xmla.model.types.XmlaFormat;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.xml.serialize.OutputFormat;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XmlaQuery
implements XmlaConstants {
    public static final String CHARSET_ENCODING = "UTF-8";
    private final String clientUUID;
    @Nullable
    private final String sessionId_;
    private final List<XmlaProperty> properties;
    @Nullable
    private String beginSessionSessionId_;
    private boolean beginSessionHeaderAttached;
    private boolean endSessionHeaderAttached;

    public XmlaQuery(String uuid) {
        this(uuid, null, Collections.emptyList());
    }

    public XmlaQuery(String uuid, @Nullable String sessionId, List<XmlaProperty> properties) {
        this.clientUUID = uuid;
        this.sessionId_ = sessionId;
        this.beginSessionSessionId_ = null;
        this.properties = properties;
        this.beginSessionHeaderAttached = false;
        this.endSessionHeaderAttached = false;
    }

    protected XmlaQuery(XmlaQuery that, @Nullable String newSessionId, @Nullable String newSchemaName) {
        this.clientUUID = that.clientUUID;
        if (newSessionId == null) {
            this.sessionId_ = that.sessionId_;
            this.beginSessionSessionId_ = null;
        } else {
            this.sessionId_ = newSessionId;
            this.beginSessionSessionId_ = null;
        }
        this.properties = new ArrayList<XmlaProperty>();
        for (XmlaProperty thatProperty : that.properties) {
            if (thatProperty.getName().equals("Catalog") && newSchemaName != null) {
                this.properties.add(new XmlaCatalogProperty(newSchemaName));
                continue;
            }
            try {
                this.properties.add((XmlaProperty)thatProperty.clone());
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("internal error : unsupported clone method");
            }
        }
    }

    public abstract XmlaQuery duplicateForLoadTesting(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4);

    public String getClientUUID() {
        return this.clientUUID;
    }

    public String getTrackingInfo() {
        String kind = this.getKind().name();
        String schema = this.getSchema();
        String type = this.getClass().getSimpleName();
        String uuid = this.getClientUUID();
        return kind + " (" + (String)(schema != null ? "schema:" + schema : "schema:none") + ") " + type + " " + uuid;
    }

    public boolean isSchemaLifeCycle() {
        return false;
    }

    @Nullable
    public String getSchemaLifeCycleName() {
        return null;
    }

    public boolean isUnloadSchema() {
        return false;
    }

    public boolean isLoadSchema() {
        return false;
    }

    public boolean isUnloadPartitions() {
        return false;
    }

    public boolean isLoadPartitions() {
        return false;
    }

    public boolean isLoadMeasureGroup() {
        return false;
    }

    public boolean isFullLoadSchema() {
        return false;
    }

    public boolean isLoadSchemaWithOffline() {
        return false;
    }

    @Nullable
    public String getOfflineSnapshot() {
        return null;
    }

    public boolean isMdxStatement() {
        return false;
    }

    public boolean isDiscover() {
        return false;
    }

    public boolean isApplyPermissions() {
        return false;
    }

    @Nullable
    public String getSchema() {
        return this.getCatalog();
    }

    @Nullable
    public String getMdxForCancelReport() {
        return null;
    }

    @Nullable
    public String getSchemaFactoryFileName() {
        return null;
    }

    @Nullable
    public String getSchemaDefinition() {
        return null;
    }

    public boolean isSchemaWrite() {
        return false;
    }

    public boolean isSession() {
        return this.isBeginSession() || this.isEndSession();
    }

    public void attachBeginSessionHeader() {
        this.beginSessionHeaderAttached = true;
    }

    public boolean hasBeginSessionHeader() {
        return this.beginSessionHeaderAttached || this.isBeginSession();
    }

    protected boolean isBeginSession() {
        return false;
    }

    public void attachEndSessionHeader() {
        this.endSessionHeaderAttached = true;
    }

    public boolean hasEndSessionHeader() {
        return this.endSessionHeaderAttached;
    }

    public boolean isEndSession() {
        return false;
    }

    public XmlaQueryKind getKind() {
        return XmlaQueryKind.OTHER;
    }

    public abstract String getUserFriendlyTypeName();

    public boolean isMonitored() {
        return false;
    }

    public abstract String getSoapAction();

    @Nullable
    public String getSessionId() {
        if (this.beginSessionSessionId_ != null) {
            return this.beginSessionSessionId_;
        }
        return this.sessionId_;
    }

    public void setSessionIdOnBeginSession(String sessionId) {
        this.beginSessionSessionId_ = sessionId;
    }

    protected void addProperties(XmlaCatalogProperty prop) {
        this.properties.add(prop);
    }

    public List<XmlaProperty> getProperties() {
        return this.properties;
    }

    @Nullable
    public String getCatalog() {
        for (XmlaProperty xmlaProperty : this.getProperties()) {
            if (!xmlaProperty.getName().equals("Catalog")) continue;
            return xmlaProperty.toXmlaString();
        }
        return null;
    }

    @Nullable
    private XmlaFormatProperty getFormatProperty() {
        for (XmlaProperty xmlaProperty : this.getProperties()) {
            if (!(xmlaProperty instanceof XmlaFormatProperty)) continue;
            return (XmlaFormatProperty)xmlaProperty;
        }
        return null;
    }

    @Nullable
    public XmlaLocaleIdentifierProperty getLocaleIdentifierProperty() {
        for (XmlaProperty property : this.properties) {
            if (!(property instanceof XmlaLocaleIdentifierProperty)) continue;
            return (XmlaLocaleIdentifierProperty)property;
        }
        return null;
    }

    public XmlaFormat getActualFormat() {
        return this.getActualFormat(null);
    }

    public XmlaFormat getActualFormat(@Nullable XmlaFormat nativeFormat) {
        XmlaFormat value;
        XmlaFormatProperty formatProperty = this.getFormatProperty();
        XmlaFormat xmlaFormat = value = formatProperty != null ? (XmlaFormat)formatProperty.getValue() : null;
        if (value == null || value == XmlaFormat.Native) {
            if (nativeFormat == null) {
                return this.getActualFormatForNative();
            }
            return nativeFormat;
        }
        return value;
    }

    protected abstract XmlaFormat getActualFormatForNative();

    public boolean isExecutionModePrepare() {
        for (XmlaProperty xmlaProperty : this.getProperties()) {
            if (!(xmlaProperty instanceof XmlaExecutionModeProperty)) continue;
            XmlaExecutionModeProperty executionModeProperty = (XmlaExecutionModeProperty)xmlaProperty;
            XmlaExecutionMode executionMode = (XmlaExecutionMode)executionModeProperty.getValue();
            return executionMode == XmlaExecutionMode.Prepare;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void emitSoapEnvelope(CdXmlaCaller caller, OutputStream out) {
        try {
            BufferedWriter underlying = new BufferedWriter(new OutputStreamWriter(out, CHARSET_ENCODING));
            PrintWriter writer = new PrintWriter(underlying);
            OutputFormat format = new OutputFormat("xml", CHARSET_ENCODING, false);
            format.setOmitXMLDeclaration(true);
            format.setLineWidth(0);
            XmlaSerializer serializer = new XmlaSerializer(caller, out, writer, format);
            serializer.startDocument();
            AttributesImpl envelopeAttrs = new AttributesImpl();
            envelopeAttrs.addAttribute(null, null, "xmlns:soap", "string", "http://schemas.xmlsoap.org/soap/envelope/");
            serializer.startElement(null, null, "soap:Envelope", envelopeAttrs);
            this.emitSoapEnvelopeHeader(serializer);
            this.emitSoapEnvelopeBody(serializer);
            serializer.endElement(null, null, "soap:Envelope");
            serializer.endDocument();
        }
        catch (UnsupportedEncodingException | SAXException ex) {
            throw new CdRuntimeException((Throwable)ex, "SOAP request error");
        }
    }

    protected void emitSoapEnvelopeHeader(XmlaSerializer serializer) throws SAXException {
        serializer.startElement(null, null, "soap:Header", null);
        if (!this.hasEndSessionHeader() && this.getSessionId() != null) {
            AttributesImpl sessionAttrs = new AttributesImpl();
            sessionAttrs.addAttribute(null, null, "SessionId", "string", this.getSessionId());
            sessionAttrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
            this.doEmitSoapSessionElement(serializer, sessionAttrs);
        }
        this.doEmitSoapEnvelopeHeader(serializer);
        serializer.endElement(null, null, "soap:Header");
    }

    protected void doEmitSoapSessionElement(XmlaSerializer serializer, AttributesImpl attrs) throws SAXException {
        serializer.startElement(null, null, "Session", attrs);
        serializer.endElement(null, null, "Session");
    }

    protected void doEmitSoapEnvelopeHeader(XmlaSerializer serializer) throws SAXException {
        if (this.hasBeginSessionHeader()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
            serializer.startElement(null, null, "BeginSession", attrs);
            serializer.endElement(null, null, "BeginSession");
        }
        if (this.hasEndSessionHeader() && this.getSessionId() != null) {
            AttributesImpl sessionAttrs = new AttributesImpl();
            sessionAttrs.addAttribute(null, null, "SessionId", "string", this.getSessionId());
            sessionAttrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
            serializer.startElement(null, null, "EndSession", sessionAttrs);
            serializer.endElement(null, null, "EndSession");
        }
    }

    protected final void emitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
        serializer.startElement(null, null, "soap:Body", null);
        this.doEmitSoapEnvelopeBody(serializer);
        serializer.endElement(null, null, "soap:Body");
    }

    protected void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
    }

    protected void doEmitSoapProperties(XmlaSerializer serializer) throws SAXException {
        serializer.startElement(null, null, "Properties", null);
        if (!this.properties.isEmpty()) {
            serializer.startElement(null, null, "PropertyList", null);
            for (XmlaProperty property : this.properties) {
                serializer.addElement(property.getName(), property.toXmlaString());
            }
            serializer.endElement(null, null, "PropertyList");
        }
        serializer.endElement(null, null, "Properties");
    }

    public void fixMissingCatalog(Supplier<String> firstAuthorizedSchemaName) {
    }
}

