/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.discover.bean;

import crazydev.common.utils.CdStringUtils;
import crazydev.xmla.model.annotation.XmlaIgnore;
import crazydev.xmla.model.discover.IXmlaMDSchemaMember;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberProperties;
import crazydev.xmla.model.types.XmlaCubeSource;
import crazydev.xmla.model.types.XmlaMemberType;
import crazydev.xmla.model.types.XmlaScope;
import crazydev.xmla.model.types.XmlaTreeOp;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="row")
public class XmlaMDSchemaMemberBean
implements IXmlaMDSchemaMember {
    public static final Comparator<IXmlaMDSchemaMember> RANK_COMPARATOR = new Comparator<IXmlaMDSchemaMember>(){

        @Override
        public int compare(IXmlaMDSchemaMember o1, IXmlaMDSchemaMember o2) {
            Comparable thisVal = o1.getRank();
            Comparable anotherVal = o2.getRank();
            return thisVal.compareTo(anotherVal);
        }
    };
    @XmlElement(name="CATALOG_NAME")
    private String catalogName;
    @XmlElement(name="CUBE_NAME")
    private String cubeName;
    @XmlElement(name="CUBE_SOURCE")
    @XmlJavaTypeAdapter(value=XmlaCubeSource.Adapter.class)
    private XmlaCubeSource cubeSource;
    @XmlElement(name="DIMENSION_UNIQUE_NAME")
    private String dimensionUniqueName;
    @XmlElement(name="HIERARCHY_UNIQUE_NAME")
    private String hierarchyUniqueName;
    @XmlElement(name="LEVEL_UNIQUE_NAME")
    private String levelUniqueName;
    @XmlElement(name="LEVEL_NUMBER")
    private int levelNumber;
    @XmlElement(name="MEMBER_NAME")
    private String memberName;
    @XmlElement(name="MEMBER_UNIQUE_NAME")
    private String memberUniqueName;
    @XmlElement(name="MEMBER_TYPE")
    private XmlaMemberType memberType;
    @XmlElement(name="MEMBER_GUID")
    private String memberGuid;
    @XmlElement(name="MEMBER_CAPTION")
    private String memberCaption;
    @XmlElement(name="CHILDREN_CARDINALITY")
    private int childrenCardinality;
    @XmlElement(name="PARENT_LEVEL")
    private int parentLevel;
    @XmlElement(name="PARENT_UNIQUE_NAME")
    private String parentUniqueName;
    @XmlElement(name="PARENT_COUNT")
    private int parentCount;
    @XmlElement(name="DESCRIPTION")
    private String description;
    @XmlElement(name="EXPRESSION")
    private String expression;
    @XmlElement(name="MEMBER_KEY")
    private String memberKey;
    @XmlElement(name="IS_PLACEHOLDERMEMBER")
    private boolean isPlaceholderMember;
    @XmlElement(name="IS_DATAMEMBER")
    private boolean isDataMember;
    @XmlElement(name="SCOPE")
    private XmlaScope scope;
    @XmlElement(name="TREE_OP")
    @XmlJavaTypeAdapter(value=XmlaTreeOp.Adapter.class)
    private XmlaTreeOp treeOp;
    @XmlElement(name="MEMBER_ORDINAL")
    private int memberOrdinal;
    @XmlTransient
    @XmlaIgnore
    @Nullable
    private XmlaMDSchemaMemberProperties properties;
    @XmlTransient
    @XmlaIgnore
    private Comparable rank;

    private XmlaMDSchemaMemberBean() {
    }

    public XmlaMDSchemaMemberBean(String catalogName, String cubeName, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, int levelNumber, String memberName, @Nullable String memberCaption, String memberUniqueName, int childrenCardinality, int parentLevel, String parentUniqueName, String memberKey, XmlaMemberType memberType, @Nullable XmlaMDSchemaMemberProperties properties, Comparable rank) {
        this.catalogName = catalogName;
        this.cubeName = cubeName;
        this.dimensionUniqueName = dimensionUniqueName;
        this.hierarchyUniqueName = hierarchyUniqueName;
        this.levelUniqueName = levelUniqueName;
        this.levelNumber = levelNumber;
        this.memberName = memberName;
        this.memberUniqueName = memberUniqueName;
        this.memberType = memberType;
        this.memberCaption = CdStringUtils.isNullOrBlank((String)memberCaption) ? memberName : memberCaption;
        this.childrenCardinality = childrenCardinality;
        this.parentLevel = parentLevel;
        this.parentUniqueName = parentUniqueName;
        this.parentCount = parentUniqueName == null ? 0 : 1;
        this.memberKey = memberKey;
        this.isPlaceholderMember = false;
        this.isDataMember = false;
        this.memberOrdinal = 0;
        this.properties = properties;
        this.rank = rank;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    @Override
    public String getLevelUniqueName() {
        return this.levelUniqueName;
    }

    @Override
    public int getLevelNumber() {
        return this.levelNumber;
    }

    @Override
    public int getMemberOrdinal() {
        return this.memberOrdinal;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public String getMemberUniqueName() {
        return this.memberUniqueName;
    }

    @Override
    public XmlaMemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public String getMemberGuid() {
        return this.memberGuid;
    }

    @Override
    public String getMemberCaption() {
        return this.memberCaption;
    }

    @Override
    public int getChildrenCardinality() {
        return this.childrenCardinality;
    }

    @Override
    public int getParentLevel() {
        return this.parentLevel;
    }

    @Override
    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    @Override
    public int getParentCount() {
        return this.parentCount;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getMemberKey() {
        return this.memberKey;
    }

    @Override
    public boolean getIsPlaceholderMember() {
        return this.isPlaceholderMember;
    }

    @Override
    public boolean getIsDataMember() {
        return this.isDataMember;
    }

    @Override
    public XmlaScope getScope() {
        return this.scope;
    }

    @Override
    public XmlaTreeOp getTreeOp() {
        return this.treeOp;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public XmlaCubeSource getCubeSource() {
        return this.cubeSource;
    }

    @Override
    public Comparable getRank() {
        return this.rank;
    }

    @Override
    @Nullable
    public XmlaMDSchemaMemberProperties getProperties() {
        return this.properties;
    }

    @Override
    public void clearProperties() {
        if (this.properties != null) {
            this.properties = null;
        }
    }

    public String toString() {
        return "(" + String.valueOf(this.rank) + ") " + this.memberUniqueName;
    }
}

