/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.discover.bean;

import crazydev.common.utils.CdStringUtils;
import crazydev.xmla.model.discover.IXmlaMDSchemaHierarchy;
import crazydev.xmla.model.types.XmlaCubeSource;
import crazydev.xmla.model.types.XmlaDimensionType;
import crazydev.xmla.model.types.XmlaHierarchyStructure;
import crazydev.xmla.model.types.XmlaInstanceSelection;
import crazydev.xmla.model.types.XmlaPropertyOrigin;
import crazydev.xmla.model.types.XmlaPropertyVisibility;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="row")
public class XmlaMDSchemaHierarchyBean
implements IXmlaMDSchemaHierarchy {
    @XmlElement(name="DIMENSION_UNIQUE_NAME")
    private String dimensionUniqueName;
    @XmlElement(name="HIERARCHY_NAME")
    private String hierarchyName;
    @XmlElement(name="HIERARCHY_UNIQUE_NAME")
    private String hierarchyUniqueName;
    @XmlElement(name="HIERARCHY_GUID")
    private String hierarchyGuid;
    @XmlElement(name="HIERARCHY_CAPTION")
    private String hierarchyCaption;
    @XmlElement(name="DIMENSION_TYPE")
    private XmlaDimensionType dimensionType;
    @XmlElement(name="HIERARCHY_CARDINALITY")
    private int hierarchyCardinality;
    @XmlElement(name="DEFAULT_MEMBER")
    private String defaultMember;
    @XmlElement(name="ALL_MEMBER")
    private String allMember;
    @XmlElement(name="DESCRIPTION")
    private String description;
    @XmlElement(name="STRUCTURE")
    private XmlaHierarchyStructure structure;
    @XmlElement(name="IS_VIRTUAL")
    private boolean isVirtual;
    @XmlElement(name="IS_READWRITE")
    private boolean isReadwrite;
    @XmlElement(name="DIMENSION_UNIQUE_SETTINGS")
    private int dimensionUniqueSettings;
    @XmlElement(name="DIMENSION_MASTER_UNIQUE_NAME")
    private String dimensionMasterUniqueName;
    @XmlElement(name="DIMENSION_IS_VISIBLE")
    private boolean dimensionIsVisible;
    @XmlElement(name="HIERARCHY_ORDINAL")
    private int hierarchyOrdinal;
    @XmlElement(name="DIMENSION_IS_SHARED")
    private boolean dimensionIsShared;
    @XmlElement(name="HIERARCHY_IS_VISIBLE")
    private boolean hierarchyIsVisible;
    @XmlElement(name="HIERARCHY_ORIGIN")
    @XmlJavaTypeAdapter(value=XmlaPropertyOrigin.Adapter.class)
    private XmlaPropertyOrigin hierarchyOrigin;
    @XmlElement(name="HIERARCHY_DISPLAY_FOLDER")
    private String hierarchyDisplayFolder;
    @XmlElement(name="INSTANCE_SELECTION")
    private XmlaInstanceSelection instanceSelection;
    @XmlElement(name="HIERARCHY_VISIBILITY")
    private XmlaPropertyVisibility hierarchyVisibility;
    @XmlElement(name="CATALOG_NAME")
    private String catalogName;
    @XmlElement(name="CUBE_NAME")
    private String cubeName;
    @XmlElement(name="CUBE_SOURCE")
    @XmlJavaTypeAdapter(value=XmlaCubeSource.Adapter.class)
    private XmlaCubeSource cubeSource;
    @XmlElement(name="GROUPING_BEHAVIOR")
    private Integer groupingBehavior;

    private XmlaMDSchemaHierarchyBean() {
    }

    public XmlaMDSchemaHierarchyBean(String catalogName, String cubeName, String dimensionUniqueName, String hierarchyName, String hierarchyUniqueName, @Nullable String hierarchyCaption, int hierarchyCardinality, @Nullable String defaultMember, String allMember, int hierarchyOrdinal, boolean isVisible, XmlaDimensionType type, boolean excelTimeLine, boolean excelTimeLineVisible, String hierarchyDisplayFolder) {
        this.catalogName = catalogName;
        this.cubeName = cubeName;
        this.dimensionUniqueName = dimensionUniqueName;
        this.hierarchyName = hierarchyName;
        this.hierarchyUniqueName = hierarchyUniqueName;
        this.hierarchyDisplayFolder = hierarchyDisplayFolder;
        this.hierarchyCaption = CdStringUtils.isNullOrBlank((String)hierarchyCaption) ? hierarchyName : hierarchyCaption;
        this.hierarchyCardinality = hierarchyCardinality;
        this.defaultMember = defaultMember;
        this.allMember = allMember;
        this.hierarchyOrdinal = 1 + hierarchyOrdinal;
        this.dimensionType = type;
        this.structure = XmlaHierarchyStructure.MD_STRUCTURE_FULLYBALANCED;
        this.isVirtual = false;
        this.isReadwrite = false;
        this.dimensionUniqueSettings = 1;
        this.dimensionIsVisible = true;
        this.dimensionIsShared = true;
        this.hierarchyIsVisible = isVisible;
        this.hierarchyOrigin = XmlaPropertyOrigin.MD_USER_DEFINED;
        this.instanceSelection = XmlaInstanceSelection.MD_INSTANCE_SELECTION_NONE;
        if (excelTimeLine) {
            this.hierarchyOrigin = new XmlaPropertyOrigin(6);
            if (!excelTimeLineVisible) {
                this.hierarchyIsVisible = false;
            }
        }
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getHierarchyName() {
        return this.hierarchyName;
    }

    @Override
    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    @Override
    public String getHierarchyGuid() {
        return this.hierarchyGuid;
    }

    @Override
    public String getHierarchyCaption() {
        return this.hierarchyCaption;
    }

    @Override
    public XmlaDimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getHierarchyCardinality() {
        return this.hierarchyCardinality;
    }

    @Override
    public String getDefaultMember() {
        return this.defaultMember;
    }

    @Override
    public String getAllMember() {
        return this.allMember;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public XmlaHierarchyStructure getStructure() {
        return this.structure;
    }

    @Override
    public boolean getIsVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean getIsReadwrite() {
        return this.isReadwrite;
    }

    @Override
    public int getDimensionUniqueSettings() {
        return this.dimensionUniqueSettings;
    }

    @Override
    public String getDimensionMasterUniqueName() {
        return this.dimensionMasterUniqueName;
    }

    @Override
    public boolean getDimensionIsVisible() {
        return this.dimensionIsVisible;
    }

    @Override
    public int getHierarchyOrdinal() {
        return this.hierarchyOrdinal;
    }

    @Override
    public boolean getDimensionIsShared() {
        return this.dimensionIsShared;
    }

    @Override
    public boolean getHierarchyIsVisible() {
        return this.hierarchyIsVisible;
    }

    @Override
    public XmlaPropertyOrigin getHierarchyOrigin() {
        return this.hierarchyOrigin;
    }

    @Override
    public String getHierarchyDisplayFolder() {
        return this.hierarchyDisplayFolder;
    }

    @Override
    public XmlaInstanceSelection getInstanceSelection() {
        return this.instanceSelection;
    }

    @Override
    public Integer getGroupingBehavior() {
        return this.groupingBehavior;
    }

    @Override
    public XmlaPropertyVisibility getHierarchyVisibility() {
        return this.hierarchyVisibility;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public XmlaCubeSource getCubeSource() {
        return this.cubeSource;
    }
}

