/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.discover.bean;

import crazydev.common.utils.CdStringUtils;
import crazydev.xmla.model.discover.IXmlaMDSchemaDimension;
import crazydev.xmla.model.types.XmlaCubeSource;
import crazydev.xmla.model.types.XmlaDimensionType;
import crazydev.xmla.model.types.XmlaDimensionUniqueSettings;
import crazydev.xmla.model.types.XmlaPropertyVisibility;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="row")
public class XmlaMDSchemaDimensionBean
implements IXmlaMDSchemaDimension {
    @XmlElement(name="CUBE_SOURCE")
    @XmlJavaTypeAdapter(value=XmlaCubeSource.Adapter.class)
    private XmlaCubeSource cubeSource;
    @XmlElement(name="CUBE_NAME")
    private String cubeName;
    @XmlElement(name="CATALOG_NAME")
    private String catalogName;
    @XmlElement(name="DIMENSION_NAME")
    private String dimensionName;
    @XmlElement(name="DIMENSION_UNIQUE_NAME")
    private String dimensionUniqueName;
    @XmlElement(name="DIMENSION_GUID")
    private String dimensionGuid;
    @XmlElement(name="DIMENSION_CAPTION")
    private String dimensionCaption;
    @XmlElement(name="DIMENSION_ORDINAL")
    private int dimensionOrdinal;
    @XmlElement(name="DIMENSION_TYPE")
    private XmlaDimensionType dimensionType;
    @XmlElement(name="DIMENSION_CARDINALITY")
    private int dimensionCardinality;
    @XmlElement(name="DEFAULT_HIERARCHY")
    private String defaultHierarchy;
    @XmlElement(name="DESCRIPTION")
    private String description;
    @XmlElement(name="IS_VIRTUAL")
    private boolean isVirtual;
    @XmlElement(name="IS_READWRITE")
    private boolean isReadWrite;
    @XmlElement(name="DIMENSION_UNIQUE_SETTINGS")
    private XmlaDimensionUniqueSettings dimensionUniqueSettings;
    @XmlElement(name="DIMENSION_MASTER_NAME")
    private String dimensionMasterUniqueName;
    @XmlElement(name="DIMENSION_IS_VISIBLE")
    private boolean dimensionIsVisible;
    @XmlElement(name="DIMENSION_VISIBILITY")
    private XmlaPropertyVisibility dimensionVisibility;

    private XmlaMDSchemaDimensionBean() {
    }

    public XmlaMDSchemaDimensionBean(String catalogName, String cubeName, String dimensionName, String dimensionUniqueName, @Nullable String dimensionCaption, int dimensionOrdinal, int dimensionCardinality, String defaultHierarchy, XmlaDimensionType type) {
        this.catalogName = catalogName;
        this.cubeName = cubeName;
        this.dimensionName = dimensionName;
        this.dimensionUniqueName = dimensionUniqueName;
        this.dimensionCaption = CdStringUtils.isNullOrBlank((String)dimensionCaption) ? dimensionName : dimensionCaption;
        this.dimensionOrdinal = 1 + dimensionOrdinal;
        this.dimensionCardinality = dimensionCardinality;
        this.defaultHierarchy = defaultHierarchy;
        this.dimensionType = type;
        this.dimensionUniqueSettings = XmlaDimensionUniqueSettings.MDDIMENSIONS_MEMBER_KEY_UNIQUE;
        this.dimensionIsVisible = true;
        this.isVirtual = false;
        this.isReadWrite = false;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getDimensionGuid() {
        return this.dimensionGuid;
    }

    @Override
    public String getDimensionCaption() {
        return this.dimensionCaption;
    }

    @Override
    public int getDimensionOrdinal() {
        return this.dimensionOrdinal;
    }

    @Override
    public XmlaDimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getDimensionCardinality() {
        return this.dimensionCardinality;
    }

    @Override
    public String getDefaultHierarchy() {
        return this.defaultHierarchy;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean getIsVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean getIsReadWrite() {
        return this.isReadWrite;
    }

    @Override
    public XmlaDimensionUniqueSettings getDimensionUniqueSettings() {
        return this.dimensionUniqueSettings;
    }

    @Override
    public String getDimensionMasterUniqueName() {
        return this.dimensionMasterUniqueName;
    }

    @Override
    public boolean getDimensionIsVisible() {
        return this.dimensionIsVisible;
    }

    @Override
    public XmlaPropertyVisibility getDimensionVisibility() {
        return this.dimensionVisibility;
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public XmlaCubeSource getCubeSource() {
        return this.cubeSource;
    }
}

