package crazydev.iccube.plugin.tableAggregator;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.IOlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import crazydev.iccube.olap.facts.column.aggregator.ISumAggregator;

import java.util.HashMap;

public class AggrEventValues implements IOlapFactTableAggregatorFactory
{
    @Override
    public IOlapFactTableAggregator newInstance()
    {
        return new IOlapFactTableAggregator()
        {
            private HashMap<Comparable, String> toCurrName;

            private Integer curreColIdx;

            private Integer valueColIdx;

            private ISumAggregator sum;

            private boolean isNull;

            private Object eventCurr;

            @Override
            public String getName()
            {
                return "AggrEventValues";
            }

            @Override
            public void init(IFactTableContext context, String measureName, String factColumnName)
            {
                sum = context.hpAggregator();
                isNull = false;
                eventCurr = null;
                valueColIdx = context.getFromColumnName(factColumnName);
                curreColIdx = context.getFromColumnName("EVENT_CURRENCY_ID");
                final IOlapMember m = context.getContextMember("date");
                toCurrName = new HashMap<>();
                context.forEachMember("Currency (Event)", member -> {
                    final Comparable id = member.getKeyValue();
                    final String name = member.getNameX();
                    if (id != null)
                    {
                        toCurrName.put(id, name);
                    }
                });
            }

            @Override
            public boolean onRow(int rowNumber, IOlapFactsTableRow row)
            {
                if (isNull)
                {
                    return false;
                }
                final Double value = row.getAsDouble(valueColIdx);
                if (value == null)
                {
                    return true;
                }
                final Comparable curr = row.getValue(curreColIdx);
                if (eventCurr == null)
                {
                    eventCurr = curr;
                }
                else if (!eventCurr.equals(curr))
                {
                    isNull = true;
                    return false;
                }
                sum.aggregate(value);
                return true;
            }

            @Override
            public OlapScalarEntity asScalarEntity()
            {
                if (eventCurr == null || isNull || sum.isEmpty())
                {
                    return OlapEmptyEntity.INSTANCE;
                }
                final String currName = toCurrName.get(eventCurr);
                return asNumericEntityWithUnit(sum.aggregation(), currName, false);
            }
        };
    }
}
