/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTimeDimensionWith extends OlapTimeDimensionFunction
{
    public OlapTimeDimensionWith(String name)
    {
        super(name, ARGS_2);
    }

    @Nullable
    @Override
    protected String validateParameter(int i, OlapNumericEntity parameter)
    {
        if (i == 1)
        {
            final int asInt = parameter.intValue();
            if (asInt < minValue() || asInt > maxValue())
            {

                return "The parameter should in the range [" + minValue() + "," + maxValue() + "], got : " + asInt;
            }
        }

        return null;
    }

    abstract int minValue();

    abstract int maxValue();
}
