/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapTimeDimensionGet extends OlapFunction
{
    public OlapTimeDimensionGet(String name)
    {
        super(OlapTimeDimensionFunction.PREFIX + "Get" + name, new OlapFunctionArgs(1));
    }

    @Override
    public OlapEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapMember member = args.toMember(context, 0, true, true);
        if (member == null || member.isAll())
        {
            return asNull();
        }

        final int getValue;
        final Comparable dateTime = member.getKeyValue();
        if (dateTime instanceof LocalDate)
        {
            LocalDate date = (LocalDate) dateTime;
            getValue = apply(date);
        }
        else if (dateTime instanceof LocalDateTime)
        {
            LocalDateTime time = (LocalDateTime) dateTime;
            getValue = apply(time);
        }
        else
        {
            return args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, member.getLevel().getUniqueName(OlapNameContext.DEFAULT_VALUES), dateTime.getClass().getSimpleName());
        }
        return new OlapNumericEntity(getValue);
    }

    abstract protected int apply(LocalDateTime time);

    abstract protected int apply(LocalDate time);
}
