/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.pub.utils.ic3DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionFirstDayOfWeekOfMonthFunction extends OlapTimeDimensionDayOfWeekOfFunction
{
    public static final String NAME = "FirstDayOfWeekOfMonth";

    public OlapTimeDimensionFirstDayOfWeekOfMonthFunction()
    {
        super(NAME);
    }

    @Override
    protected LocalDateTime apply(LocalDateTime time, OlapNumericEntity[] parameters)
    {
        return ic3DateTime.firstDayOfWeekOfMonth(time, firstAsInteger(parameters));
    }

    @Override
    protected LocalDate apply(LocalDate time, OlapNumericEntity[] parameters)
    {
        return ic3DateTime.firstDayOfWeekOfMonth(time, firstAsInteger(parameters));
    }

    @Override
    protected OlapLevelType getLevelChanged()
    {
        return OlapLevelType.YEAR;
    }
}
