/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionAsOfYesterday extends OlapTimeDimensionAsOfBase
{
    public static final String NAME = "dtAsOfYesterday";

    public OlapTimeDimensionAsOfYesterday()
    {
        super(NAME, new OlapFunctionArgs(1));
    }

    @Override
    Object getLookupKey(GFContext context, GFFunctionArgs args, boolean isDateType)
    {
        if (isDateType)
        {
            return LocalDate.now().minusDays(1);
        }
        else
        {
            return LocalDateTime.now().minusDays(1);
        }
    }
}
