/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.member.OlapMember;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import java.util.function.Predicate;

/**
 * icCube function to navigate in the time dimension
 */
public class OlapDatesYtdTimeDimensionFunction extends OlapDatesTimeDimensionFunction
{
    public static final String NAME = "DatesYtd";

    public OlapDatesYtdTimeDimensionFunction()
    {
        super(NAME);
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDateTime time)
    {
        final int year = time.getYear();
        return (member) -> ((LocalDateTime) member.getKeyValue()).getYear() == year;
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDate time)
    {
        final int year = time.getYear();
        return (member) -> ((LocalDate) member.getKeyValue()).getYear() == year;
    }

    protected OlapLevelType getLevelChanged()
    {
        return OlapLevelType.YEAR;
    }
}