/*
 * Copyright 2014 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.olap.entity.member.OlapMember;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import java.util.function.Predicate;

/**
 * icCube function to navigate in the time dimension
 */
public class OlapDatesWeekTimeDimensionFunction extends OlapDatesTimeDimensionFunction
{
    public static final String NAME = "DatesWeek";

    public OlapDatesWeekTimeDimensionFunction()
    {
        super(NAME);
    }

    @Nullable
    @Override
    protected OlapMember getEndPeriodMember(OlapMember member)
    {
        return getLastExistingWeekday(member, 1, 7);
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDateTime time)
    {
        final int week = time.getWeekOfWeekyear();
        return (member) -> ((LocalDateTime) member.getKeyValue()).getWeekOfWeekyear() == week;
    }

    @Override
    protected Predicate<OlapMember> filter(LocalDate time)
    {
        final int week = time.getWeekOfWeekyear();
        return (member) -> ((LocalDate) member.getKeyValue()).getWeekOfWeekyear() == week;
    }

    @Override
    protected boolean compactDefaultValue()
    {
        return false;
    }

    protected boolean errorOnLevelMismatch()
    {
        return true;
    }
}
