/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.collection.olapiterator.OlapCompactIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;

import java.util.Arrays;

/**
 * icCube function to navigate in the time dimension
 */
public class OlapDatesItdTimeDimensionFunction extends OlapMdxTimeNavigationFunction
{
    private static final String NAME = "DatesItd";

    private static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2);

    public OlapDatesItdTimeDimensionFunction()
    {
        super(OlapTimeDimensionFunction.PREFIX + NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapMember member = args.toMember(context, 0, true, true);
        if (member == null || member.isMdxNull() || member.isAll())
        {
            return OlapSetFactory.empty();
        }
        final boolean compact = args.toOptionalBoolean(context, 1, true);

        final OlapLevel memberLevel = member.getLevel();

        // check it's a time dimension
        final OlapBuilderInputType[] keyType = memberLevel.getMemberKeyType();
        if (keyType != null && (keyType.length != 1 || !keyType[0].isDateType()))
        {
            return args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, memberLevel.getUniqueName(OlapNameContext.DEFAULT_VALUES), Arrays.toString(keyType));
        }

        final OlapMemberFilter filter = context.getMemberFilter();
        OlapMember rootMember = member.getHierarchy().getAllMember();
        if (rootMember == null)
        {
            rootMember = member.getHierarchy().getFirstLevel().getMembers(filter).getIterator(false).next();
            if (rootMember == null)
            {
                return OlapSetFactory.instance(member);
            }
        }
        final OlapMember startMember = rootMember.getFirstDescendant(filter, memberLevel);
        if (startMember == null)
        {
            return OlapSetFactory.instance(member);
        }

        final OlapTupleSet set = memberLevel.createMemberRange(filter, startMember, member);
        return compact ? OlapCompactIterator.newInstance(set, false) : set;
    }


}
