/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.plugin.function.OlapPluginTwoExprStatFunctions;

/**
 * Evaluates a set and returns the average of the non empty values of the cells in the set,
 * averaged over the measures in the set or over a specified measure.
 * <pre>
 * WAvg( Set_Expression , Numeric_Expression [, Numeric_Expression ] )
 * </pre>
 * If a set of empty tuples or an empty set is specified, the Avg function returns an empty value.
 * <p/>
 * Analysis Services ignores nulls when calculating the average value in a set of numbers.
 * <p/>
 * If a specific numeric expression (typically a measure) is not specified, the WAvg function averages
 * each measure within the current query requestContext. If a specific measure is provided, the Avg function
 * first evaluates the measure over the set, and then the function calculates the average based on the
 * specified measure.
 */
public class OlapWAvgFunction implements OlapPluginTwoExprStatFunctions
{
    private double sum = 0.0;

    private double weight = 0.0;

    public OlapWAvgFunction()
    {
    }

    @Override
    public OlapWAvgFunction newInstance()
    {
        return new OlapWAvgFunction();
    }

    @Override
    public void addValue(double valueX, double valueY)
    {
        sum += valueX * valueY;
        weight += valueY;
    }

    @Override
    public boolean isResultEmpty()
    {
        return weight == 0.0;
    }

    @Override
    public double calculate()
    {
        return sum / weight;
    }
}
