/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;

/**
 * DistributionRank( Set_Expression , Vi , lookupValue  )
 *
 * Returns a value depending on the position, in the sorted set of values, of the lookupValue
 */
public class OlapDistributionRankFunction extends OlapBaseNumericStatisticalFunction
{
    public static final String NAME = "DistributionRank";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3)
    {
        @Override
        public boolean isLambda(int pos)
        {
            return pos == 1;
        }
    };

    public OlapDistributionRankFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    protected OlapSetCalculatorOneExpression createCalculator(GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args)
    {
        final double lookupValue = args.toDouble(context, 2);

        return new OlapSetCalculatorOneExpression()
        {
            int count = 0;

            int countBellow = 0;

            int countMatch = 0;

            @Override
            public void addValue(double value)
            {
                count++;
                if (value < lookupValue)
                {
                    countBellow++;
                }
                else if (value == lookupValue)
                {
                    countMatch++;
                }
            }

            @Override
            public boolean isResultEmpty()
            {
                return count == 0;
            }

            @Override
            public double calculate()
            {
                if (count <= 1)
                {
                    return 0.0;
                }

                double value = (countBellow + (countMatch + 1.0) / 2 - 1) / (count - 1.0);
                return Math.max(0, Math.min(value, 1.0));
            }
        };
    }

}
