/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;

/**
 * DistributionFlat( Set_Expression , Vi , lookupValue  )
 *
 * Return a value between 0 and 1 (where 0, if min and 1 if max)
 *
 * This assumes the probability is constant defined by the min/max values.
 * (lookupValue - min) / (max - min)
 */
public class OlapDistributionFlatFunction extends OlapBaseNumericStatisticalFunction
{
    public static final String NAME = "DistributionFlat";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3)
    {
        @Override
        public boolean isLambda(int pos)
        {
            return pos == 1;
        }
    };

    public OlapDistributionFlatFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    protected OlapSetCalculatorOneExpression createCalculator(GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args)
    {
        final double lookupValue = args.toDouble(context, 2);

        return new OlapSetCalculatorOneExpression()
        {
            double min = Double.MAX_VALUE;

            double max = -Double.MAX_VALUE;

            @Override
            public void addValue(double value)
            {
                min = Math.min(min, value);
                max = Math.max(max, value);
            }

            @Override
            public boolean isResultEmpty()
            {
                return min == Double.MAX_VALUE;
            }

            @Override
            public double calculate()
            {
                final double value;
                if (min == max)
                {
                    value = lookupValue < min ? 0 : lookupValue > min ? 1 : 0.5;
                }
                else
                {
                    value = (lookupValue - min) / (max - min);
                }
                return Math.max(0, Math.min(value, 1.0));
            }
        };
    }

}
