/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

import java.util.ArrayList;
import java.util.List;

public abstract class OlapBaseInterpolateColorFunction extends OlapScalarEntityFunction
{
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, OlapFunctionArgs.N)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return OlapFunctionArgumentType.VALUE;
            }
        }
    };

    public OlapBaseInterpolateColorFunction(String name)
    {
        super(name, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final double lookupPos = args.toDouble(context, 0);

        final List<Integer> colors = new ArrayList<>();

        for (int idx = 1; idx < args.size(); idx++)
        {
            colors.add(args.toInteger(context, idx));
        }

        // -> find the position
        final int color;
        if (lookupPos >= 1.0 || colors.size() == 1)
        {
            color = CdCollections.last(colors);
        }
        else if (lookupPos <= 0.0)
        {
            color = CdCollections.first(colors);
        }
        else
        {
            int buckets = colors.size() - 1;
            int index = (int) (lookupPos * buckets);
            int color1 = colors.get(index);
            int color2 = colors.get(index + 1);
            double bucketSize = 1.0 / buckets;
            double perc = lookupPos / bucketSize - index;
            color = interpolate(color1, color2, perc);
        }

        return new OlapNumericEntity((long) color);
    }

    protected abstract int interpolate(int color1, int color2, double perc);

}
