/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others.instr;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapMathFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIifNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFMathFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;

public class OlapCoalesceNullFunctionCallPreparedInstr extends OlapMathFunctionCallPreparedInstr
{
    public OlapCoalesceNullFunctionCallPreparedInstr(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, OlapPreparedInstr[] args)
    {
        super(functionCallInstr, functionCallArgInstrs, function, args);
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation)
    {
        final GFNode[] nArgs = createArgsGFTree(context);

        return new GFCoalesceNullFunctionCallNode(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, nArgs);
    }

    /**
     * Similar to IIF logic.
     *
     * @see GFIifNode
     */
    public static class GFCoalesceNullFunctionCallNode extends GFMathFunctionCallNode
    {
        public GFCoalesceNullFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args)
        {
            super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args);
        }

        @Override
        public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException
        {
            // [non-empty-behavior] covered
            return S_NonEmptyBehaviorOperator.coalesceEmpty(context, args);
        }

        @Override
        protected OlapEntity doEvalX(GFContext context, GFTupleEvaluator cache)
        {
            for (int ii = 0; ii < args.length; ii++)
            {
                final OlapEntity entity = args[ii].execute(context, cache);

                if (entity.isMdxNull())
                {
                    continue;
                }
                if (entity instanceof OlapTupleSet)
                {
                    final OlapTupleSet<? extends OlapTuple> set = entity.toSet(context);
                    if (!set._isEmpty())
                    {
                        return set;
                    }
                }
                else
                {
                    return entity;
                }
            }

            // return OlapEmptyEntity.INSTANCE;
            return OlapNullEntity.INSTANCE;
        }

    }
}
