/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

import java.util.ArrayList;
import java.util.List;

public class OlapVectorSFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "VectorS";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapVectorSFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        int size = args.size();

        final List<Comparable> values = new ArrayList<>();
        for (int idx = 0; idx < size; idx++)
        {
            final OlapEntity entity = args.getNonMissingArgEntity(context, idx, "numeric");
            if (!entity.isMdxNull())
            {
                final OlapScalarEntity<?> scalar = args.toValue(context, idx, "scalar");
                final Object value = scalar.asValue();
                if (value instanceof Comparable<?>)
                {
                    values.add((Comparable<?>) value);
                }
                else
                {
                    return onFunctionArgTypeMismatchError(context, idx, "comparable", value.getClass().getSimpleName());
                }
            }
        }

        return new OlapComparableVectorEntity(values, true);
    }
}