/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class OlapVectorNFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "VectorN";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapVectorNFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        int size = args.size();

        final OlapOption option = args.toOptionalOptionX(context, args.size() - 1, OlapOption.EXCLUDEEMPTY, OlapOption.INCLUDEEMPTY);
        if (option != null)
        {
            size--;
        }
        final boolean includeEmpty = option == null || option == OlapOption.INCLUDEEMPTY;

        // let's try as a set of numeric values
        final DoubleArrayList values = new DoubleArrayList(size);

        for (int idx = 0; idx < size; idx++)
        {
            final double value;
            final OlapEntity entity = args.getNonMissingArgEntity(context, idx, "numeric");
            if (entity.isMdxNull())
            {
                if (includeEmpty)
                {
                    value = 0.0;
                }
                else
                {
                    continue;
                }
            }
            else
            {
                value = args.toNumericX(context, 1, entity).doubleValue();
            }
            values.add(value);
        }

        return new OlapDoubleVectorEntity(values.toDoubleArray());
    }
}