/*
 * Copyright 1999 - 2017 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericStatisticalFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapSetCalculatorOneGenExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class OlapVectorKFunction extends OlapBaseGenericStatisticalFunction
{
    public static final String NAME = "VectorK";

    public OlapVectorKFunction()
    {
        super(NAME);
    }

    @Override
    protected OlapSetCalculatorOneGenExpression createCalculator(GFFunctionArgs args, OlapTupleSet set)
    {
        return new OlapSetCalculatorOneGenExpression()
        {
            DoubleArrayList arrayList = new DoubleArrayList();

            @Override
            public boolean isResultEmpty()
            {
                return arrayList.isEmpty();
            }

            @Override
            public OlapEntity calculate()
            {
                return new OlapDoubleVectorEntity(arrayList.elements());
            }

            @Override
            public int stopIterationOrdinal()
            {
                return -1;
            }

            @Override
            public void addNull(OlapTuple setTuple, int iTupleOrdinal)
            {
            }

            @Override
            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value)
            {
                // the new value is zero, always zero
                if (setTuple.getMemberCount() != 1)
                {
                    onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "member", /* !arg */ setTuple.getFriendlyTypeName());
                    return;
                }
                if (!(value instanceof OlapNumericEntity))
                {
                    onFunctionArgTypeMismatchError(args.getErrorContext(context), 1, "numeric", /* !arg */ value.getFriendlyTypeName());
                    return;
                }
                final double valueAsDouble = ((OlapNumericEntity) value).doubleValue();
                final Comparable keyValue = setTuple.getMember(0).getKeyValue();
                if (!(keyValue instanceof Integer))
                {

                    onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "Integer", "all set member key needs to be an integer type, got " + keyValue.getClass().getSimpleName());
                    return;
                }
                final int keyAsInt = (int) keyValue;
                if (keyAsInt < 0)
                {
                    onFunctionArgTypeMismatchError(args.getErrorContext(context), 0, "Positive Integer", "all set member key needs to be a 'positive' integer type, got " + keyAsInt);
                    return;
                }
                try
                {
                    final int newSize = keyAsInt + 1;
                    CdArrayUtils.resize(arrayList, newSize);
                    arrayList.set(keyAsInt, valueAsDouble + arrayList.getDouble(keyAsInt));
                }
                catch (OutOfMemoryError error)
                {
                    // shouldn't be so bad, we requested an array we can create (most probably the user
                    arrayList.clear();  // release asap, in case it throws an exception here we're lost
                    onFunctionError(args.getErrorContext(context), OlapErrorCode.VECTOR_ERROR, "Out of memory allocating a vector of size " + keyAsInt + " (hint : member keys not compacted {0,1,2,....n,n+1} ? )");
                }
            }
        };
    }

}