/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;

import java.util.ArrayList;
import java.util.List;

public class OlapUpperCrossjoinFunction extends OlapNonScalarEntityFunction
{
    public static final String NAME = "UpperCrossjoin";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2);

    public OlapUpperCrossjoinFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "set");
        if (arg0.isMdxNull())
        {
            return OlapSetFactory.empty();
        }
        final OlapListTupleSet<? extends OlapTuple> set1 = args.toSet(context, 0).asTupleList();

        final OlapListTupleSet<? extends OlapTuple> set2;
        if (args.size() == 2)
        {
            final OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "set");
            if (arg1.isMdxNull())
            {
                return OlapSetFactory.empty();
            }
            set2 = args.toSet(context, 1).asTupleList();
        }
        else
        {
            set2 = set1;
        }

        List<OlapTuple> newList = new ArrayList<>();
        for (int i = 0; i < set1.size(); i++)
        {
            final OlapTuple tuple1 = set1.getItem(i);
            for (int j = i + 1; j < set2.size(); j++)
            {
                final OlapTuple tuple2 = set2.getItem(j);
                final OlapTuple newTuple = OlapTupleFactory.instance(args.getErrorContext(context), args.getTupleDimensionalityCache(context), null, tuple1, tuple2);
                newList.add(newTuple);
            }
        }

        return OlapSetFactory.instance(newList);
    }

}
