/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import org.jetbrains.annotations.Nullable;

public class OlapSetPropertyFunction extends OlapNonScalarEntityFunction
{
    public static final String NAME = "SetProperty";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 2:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    protected OlapSetPropertyFunction(String name)
    {
        super(name, ARGS);
    }

    public OlapSetPropertyFunction()
    {
        super(NAME, ARGS);
    }

    @Nullable
    @Override
    public OlapTupleDimensionality getTupleDimensionality(GFNode[] args)
    {
        return getTupleDimensionality(args, 0);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        return doEvalForCluster(context, args, false);
    }

    protected OlapNonScalarEntity doEvalForCluster(GFContext context, GFFunctionArgs args, boolean forced)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");

        if (arg0.isMdxNull())
        {
            return OlapNullEntity.INSTANCE;
        }

        final OlapMember member = args.toMember(context, 0);
        if (member instanceof OlapMeasureMember)
        {
            final String propName = args.toString(context, 1);
            final OlapScalarEntity propValue = args.toValue(context, 2, "scalar");
            ((OlapMeasureMember) member).setPropertyValue(propName, propValue);
        }
        else
        {
            return this.onFunctionError(args.getErrorContext(context), OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, "only measures are supported for now");
        }
        return member;
    }
}