/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import org.joda.time.LocalDateTime;

import java.util.Date;

/**
 * Timestamp of the last data _ changed _ for the current schema : consistent with XMLA last update time !
 */
public class OlapSchemaUpdateTimeFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "SchemaUpdateTime";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0);

    public OlapSchemaUpdateTimeFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapSchema schema = args.getSchema(context);
        final OlapSchemaInformation schemaInformation = schema.getInformation();

        final Date timestamp = schemaInformation.getLastDataUpdatedTime();

        // default (i.e., server) timezone is used
        final LocalDateTime localDateTime = new LocalDateTime(timestamp);

        return new OlapDateTimeEntity(localDateTime);
    }

}