/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

import java.util.ArrayList;
import java.util.List;

public class OlapLookupDateRangeFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "LookupDateRange";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3);

    public OlapLookupDateRangeFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        OlapLevel level = args.toLevel(context, 0);
        final OlapLevelType levelType = OlapLookupDateFunction.checkLevelIsDate(context, args, level, getName());

        final IOlapSchemaPermission schemaPermissions = args.getSchemaPermissionsWithoutPerspective(context);
        final OlapMemberFilter memberFilter = schemaPermissions.getDimensionsPermissions(args.getCube(context)).getMemberFilter();

        final OlapScalarEntity startValue = args.toValue(context, 1, "scalar");
        final OlapScalarEntity endValue = args.toValue(context, 2, "scalar");

        final LocalDate lookupStart = OlapLookupDateFunction.toLocalDate(context, args, startValue, getName());
        final LocalDate lookupEnd = OlapLookupDateFunction.toLocalDate(context, args, endValue, getName());

        final List<OlapMember> members = new ArrayList<>();

        OlapMember member;
        final OlapIterator<OlapMember> iter = level.getMembers(memberFilter).getIterator(false);
        iter.reset();
        while ((member = iter.next()) != null)
        {
            final Comparable keyValue = member.getKeyValue();
            final LocalDate start;
            if (keyValue instanceof LocalDate)
            {
                start = (LocalDate) keyValue;
            }
            else if (keyValue instanceof LocalDateTime)
            {
                start = ((LocalDateTime) keyValue).toLocalDate();
            }
            else
            {
                continue;
            }
            // not included
            final LocalDate end = levelType.getNextDate(start.toLocalDateTime(LocalTime.MIDNIGHT)).toLocalDate();

            final boolean notInRange = (lookupStart != null && CdTimeUtils.isAfterOrEquals(lookupStart,end)) || (lookupEnd != null && start.isAfter(lookupEnd));
            if (!notInRange)
            {
                members.add(member);
            }
        }

        return OlapSetFactory.instance(members);
    }
}