/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;

public class OlapLookupByNameFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "LookupByName";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            if (pos == 1)
            {
                return OlapFunctionArgumentType.VALUE;
            }
            return super.getType(pos);
        }
    };

    public OlapLookupByNameFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|dimension|level|member");
        final OlapEntityIdentifier name = new OlapEntityIdentifier(args.toValue(context, 1, "name").asString());

        final OlapNameContext nameContext = context.getNameContext();
        final IOlapDimensionsPermission permissions = context.getDimensionsPermissions();

        // Member
        if (arg0 instanceof OlapMember)
        {
            final OlapMember member = (OlapMember) arg0;
            final OlapEntityIdentifierPart part = name.getPart(0);

            OlapMember lookup = member.lookupChildByMdxIdentifier(nameContext, permissions.getMemberFilter(),
                                                                  m -> part.isIdentifying(nameContext, m));
            return asNullable(lookup);
        }

        // Level
        if (arg0 instanceof OlapLevel)
        {
            final OlapLevel level = (OlapLevel) arg0;
            return asNullable(level.lookupEntityByMdxIdentifier(nameContext, permissions, name));
        }

        // Dimension or Hierarchy
        final OlapHierarchy hierarchy;
        if (arg0 instanceof OlapDimension)
        {
            hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension) arg0);
        }
        else if (arg0 instanceof OlapHierarchy)
        {
            hierarchy = (OlapHierarchy) arg0;
        }
        else
        {
            return args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension|level|member", arg0.getFriendlyTypeName());
        }
        return asNullable(hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, name));
    }


}