/*
 * Copyright 2014 - 2019 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.collection.CdActionStoppable;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.*;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OlapLookupByKeysFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "LookupByKeys";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, OlapFunctionArgs.N)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapLookupByKeysFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "hierarchy|dimension|level");

        final OlapHierarchy hierarchy;

        OlapLevel level = null;

        if (arg0 instanceof OlapDimension)
        {
            hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension) arg0);
        }
        else if (arg0 instanceof OlapHierarchy)
        {
            hierarchy = (OlapHierarchy) arg0;
        }
        else if (arg0 instanceof OlapLevel)
        {
            level = (OlapLevel) arg0;
            hierarchy = level.getHierarchy();
        }
        else
        {
            return args.onFunctionArgTypeMismatchError(context, 0, "hierarchy|dimension|level", arg0.getFriendlyTypeName());
        }

        // [#2447] Rationale : lower as much as possible the actual number of MDX tokens.
        final boolean withStrNumbers = args.toOptionalOptionX(context, 1, OlapOption.STR_NUMBERS) != null;

        if (withStrNumbers)
        {
            final String str = args.toString(context, 2);

            return evalForClusterWithStrNumbers(context, args, hierarchy, level, str);
        }

        final OlapMemberKey[] key = new OlapMemberKey[args.size() - 1];

        for (int ii = 0; ii < key.length; ii++)
        {
            final OlapScalarEntity scalar = args.asScalar(context, ii + 1);

            if (scalar instanceof OlapArgArrayWrapperScalarEntity wrapper && ii == 0)
            {
                return evalForClusterWithArgArrayWrapper(context, args, hierarchy, level, wrapper.asValue());
            }

            if (scalar instanceof OlapListScalarEntity)
            {
                final OlapScalarEntity[] scalars = ((OlapListScalarEntity) scalar).asValue();

                key[ii] = OlapLookupByKeyFunction.createMultiKey(Arrays.asList(scalars), hierarchy.getDimension());
            }
            else
            {
                key[ii] = OlapLookupByKeyFunction.createSingleKey(scalar, hierarchy.getDimension());
            }
        }

        return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false, true);
    }

    private OlapNonScalarEntity evalForClusterWithArgArrayWrapper(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, @Nullable OlapLevel level, OlapScalarEntity[] values)
    {
        final OlapMemberKey[] key = new OlapMemberKey[values.length];

        for (int ii = 0; ii < values.length; ii++)
        {
            final OlapScalarEntity value = values[ii];

            key[ii] = OlapLookupByKeyFunction.createSingleKey(value, hierarchy.getDimension());
        }

        return OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false, true);
    }

    private OlapNonScalarEntity evalForClusterWithStrNumbers(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, OlapLevel level, String str)
    {
        final List<OlapMember> members = new ArrayList<>();

        forEachNumber(str, (scalar) -> {

            final OlapMemberKey key = OlapLookupByKeyFunction.createSingleKey(scalar, hierarchy.getDimension());
            final OlapNonScalarEntity entity = OlapLookupByKeyFunction.lookupByKey(context, args, hierarchy, level, key, false);

            if (entity instanceof OlapMember member)
            {
                members.add(member);
            }

            return true;

        });

        return OlapSetFactory.instance(members);
    }

    private static void forEachNumber(String str, CdActionStoppable<OlapScalarEntity> action)
    {
        int start = 0;
        int end;

        while ((end = str.indexOf(",", start)) != -1)
        {
            if (end > start)
            {
                final long val = Long.parseLong(str, start, end, 10);
                if (!action.apply(new OlapNumericEntity(val)))
                {
                    return;
                }
            }
            start = end + 1;
        }

        if (start < str.length())
        {
            final long val = Long.parseLong(str, start, str.length(), 10);
            action.apply(new OlapNumericEntity(val));
        }
    }

}