/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;

import java.util.List;

public class OlapFirstNotAllLevelFunction extends OlapMdxNavigationFunction
{
    public static final String NAME = "FirstNotAllLevel";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapFirstNotAllLevelFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapHierarchy hierarchy = args.toHierarchyX(context, 0, true);

        if (hierarchy == null)
        {
            return asNull();
        }

        final List<OlapLevel> levels = hierarchy.getLevels();

        final OlapMemberFilter memberFilter = args.getMemberFilter(context);

        for (int i = 0; i < levels.size(); i++)
        {
            final OlapLevel level = levels.get(i);

            if (!level.isAll())
            {
                if (memberFilter == null || memberFilter.isAccepting(level))
                {
                    return level;
                }
            }
        }

        return asNull();
    }

}