/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.mdx.set.OlapBaseTupleTransformFunction;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public class OlapExtractOthersFunction extends OlapBaseTupleTransformFunction
{
    public static final String NAME = "ExtractOthers";

    public OlapExtractOthersFunction()
    {
        super(NAME);
    }

    @Override
    protected MyTransform createTupleTransform(Set<OlapHierarchy> hierarchies, IOlapEvaluationExceptionContext errContext, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter)
    {
        return new ExtractTuple(errContext, cache, hierarchies, tupleFilter);
    }

    private class ExtractTuple extends MyTransform
    {
        public ExtractTuple(IOlapEvaluationExceptionContext errContext, OlapTupleDimensionalityCache cache, Set<OlapHierarchy> hierarchies, @Nullable OlapTupleFilter tupleFilter)
        {
            super(errContext, cache, hierarchies, tupleFilter);
        }

        @Override
        public long fastEstimatedSize(long originalCollectionSize)
        {
            return originalCollectionSize /* we leave the collection count untouched */;
        }

        @Override
        public OlapTupleDimensionality getTupleDimensionality(@Nullable OlapTupleDimensionality dimensionality)
        {
            if (dimensionality == null)
            {
                return null;
            }

            final OlapBitSet dim = new OlapBitSet();

            final OlapBitSet dimensionalityBS = dimensionality.asBitSet();
            final OlapBitSet hierarchiesBS = hierarchiesD.asBitSet();

            for (int i = dimensionalityBS.nextSetBit(0); i >= 0; i = dimensionalityBS.nextSetBit(i + 1))
            {
                if (!hierarchiesBS.get(i))
                {
                    dim.set(i);
                }
            }

            return new OlapTupleDimensionality(dim);
        }

        @Override
        protected OlapTuple transformTuple(OlapTuple tuple)
        {
            return tuple.extractOthers(errContext, cache, tupleFilter, hierarchies);
        }

        @Override
        public IOlapIteratorTransform<OlapTuple, OlapTuple> newInstance()
        {
            return new ExtractTuple(errContext, cache, hierarchies, tupleFilter);
        }

    }

}