/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixAEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorAEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

public class OlapElementValueFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "ElementValue";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapElementValueFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity firstParam = args.toValueIfApplicable(context, 0, "matrixA/vectorA");

        if (firstParam == null || firstParam.isMdxNull())
        {
            return asEmpty();
        }

        final OlapTuple tupleToComplete;

        switch (args.size())
        {
            case 1:
            {
                tupleToComplete = OlapBlankTuple.INSTANCE;
                break;
            }
            case 2:
            {
                tupleToComplete = args.toTuple(context, 1);
                break;
            }

            default:
                return args.onFunctionArgSizeError(context);
        }

        final OlapTuple completeTuple = args.completeTupleForElementValue(context, tupleToComplete);

        if (firstParam instanceof OlapDoubleMatrixAEntity)
        {
            OlapDoubleMatrixAEntity matrixAEntity = (OlapDoubleMatrixAEntity) firstParam;
            return matrixAEntity.getElementValue(completeTuple);
        }

        if (firstParam instanceof OlapDoubleVectorAEntity)
        {
            OlapDoubleVectorAEntity vectorAEntity = (OlapDoubleVectorAEntity) firstParam;
            return vectorAEntity.getElementValue(completeTuple);
        }

        return args.onFunctionArgTypeMismatchError(context, 0, "matrixA/vectorA", firstParam.getFriendlyTypeName());
    }

}