/*
 * Copyright 1999 - 2016 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class OlapDateToStringFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "DateToString";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 1:
                case 2:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapDateToStringFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapScalarEntity entity = args.toValue(context, 0, "date");

        if (entity.isMdxNull())
        {
            return entity;
        }

        final Object entityAsValue = entity.asValue();

        final Date date;
        if (entityAsValue instanceof Date /* should never happen just in case */)
        {
            date = ((Date) entityAsValue);
        }
        else if (entityAsValue instanceof LocalDate)
        {
            date = ((LocalDate) entityAsValue).toDate();
        }
        else if (entityAsValue instanceof LocalDateTime)
        {
            date = ((LocalDateTime) entityAsValue).toDate();
        }
        else
        {
            return args.onFunctionArgTypeMismatchError(context, 0, "date|datetime", entity.getFriendlyTypeName());
        }

        // date pattern for string
        final String pattern = args.toString(context, 1);

        // locale for dates
        final Locale locale = args.toOptionalLocale(context, 2);

        final SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        final String dateAsString = formatter.format(date);

        return new OlapStringEntity(dateAsString);
    }

}