/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapRegularTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseIndexOfFunction extends OlapScalarEntityFunction
{
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapBaseIndexOfFunction(String name)
    {
        super(name, ARGS);
    }

    protected int doEvalForCluster(GFContext context, GFFunctionArgs args, boolean forIsIn)
    {
        final OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member-set");

        if (arg0.isMdxNull())
        {
            return -1;
        }

        // =================================================================================================
        // no automatic toSet : e.g., level to its members - no need to iterate at all !

        if (forIsIn)
        {
            if (arg0 instanceof OlapDimension)
            {
                return doEvalForCluster(context, args, (OlapDimension) arg0);
            }

            if (arg0 instanceof OlapHierarchy)
            {
                return doEvalForCluster(context, args, (OlapHierarchy) arg0);

            }

            if (arg0 instanceof OlapLevel)
            {
                return doEvalForCluster(context, args, (OlapLevel) arg0);

            }
        }

        // =================================================================================================
        // actual member-set ...

        final OlapTupleSet<OlapMember> memberSet;

        final OlapTupleSet<?> tupleSet = args.toSet(context, 0);

        memberSet = tupleSet.asMemberSet();

        if (memberSet == null)
        {
            return args.onFunctionArgTypeMismatchError(context, 0, "member-set", "tuple-set");
        }

// pre-cluster : not sure this isToSetApplicable is required here
//
//        if (arg0.isToSetApplicable(context))
//        {
//            final OlapTupleSet<?> tupleSet = args.toSet(0);
//
//            memberSet = tupleSet.asMemberSet();
//
//            if (memberSet == null)
//            {
//                return args.onFunctionArgTypeMismatchError(0, "member-set", "tuple-set");
//            }
//        }
//        else
//        {
//            return args.onFunctionArgTypeMismatchError(0, "member-set", arg0.getFriendlyTypeName());
//        }

        final OlapMember member = asMemberForCluster(context, args);

        if (member == null)
        {
            return -1;
        }

        return doEval(memberSet, member);
    }

    @Nullable
    private OlapMember asMemberForCluster(GFContext context, GFFunctionArgs args)
    {
        final OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "member");

        if (arg1 instanceof OlapMember)
        {
            return (OlapMember) arg1;
        }

        if (arg1 instanceof OlapRegularTuple)
        {
            final OlapRegularTuple tuple = (OlapRegularTuple) arg1;

            if (tuple.getMemberCount() == 1)
            {
                return tuple.getMember(0);
            }
        }

        return null;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapDimension dimension)
    {
        final OlapMember member = asMemberForCluster(context, args);

        if (member == null)
        {
            return -1;
        }

        return dimension.equals(member.getDimension()) ? 1 : -1;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy)
    {
        final OlapMember member = asMemberForCluster(context, args);

        if (member == null)
        {
            return -1;
        }

        return hierarchy.equals(member.getHierarchy()) ? 1 : -1;
    }

    private int doEvalForCluster(GFContext context, GFFunctionArgs args, OlapLevel level)
    {
        final OlapMember member = asMemberForCluster(context, args);

        if (member == null)
        {
            return -1;
        }

        return level.equals(member.getLevel()) ? 1 : -1;
    }

    private int doEval(OlapTupleSet<OlapMember> memberSet, OlapMember requestedMember)
    {
        boolean firstMemberChecked = false;

        final OlapIterator<OlapMember> members = memberSet.getIterator(false);

        members.reset();

        OlapMember member;
        for (int i = 0; (member = members.next()) != null; i++)
        {
            if (!firstMemberChecked)
            {
                if (!member.getHierarchy().equals(requestedMember.getHierarchy()))
                {
                    return -1;
                }

                firstMemberChecked = true;
            }

            if (requestedMember.equals(member))
            {
                return i;
            }
        }

        return -1;
    }

}