/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class OlapBaseDateFunction extends OlapScalarEntityFunction
{
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 0:
                case 1:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapBaseDateFunction(String name)
    {
        super(name, ARGS);
    }

    protected abstract OlapScalarEntity asScalarEntity(Date date);

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        // get dateString
        final String dateString = args.toString(context, 0);
        if (dateString == null)
        {
            return OlapEmptyEntity.INSTANCE;
        }
        final String pattern = args.toString(context, 1);

        // locale for dates
        final Locale locale = args.toOptionalLocale(context, 2);
        final SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        try
        {
            Date date = formatter.parse(dateString);
            return asScalarEntity(date);
        }
        catch (ParseException error)
        {
            return args.onFunctionError(context, OlapErrorCode.DATE_PARSING_ERROR, dateString, error.getMessage());
        }
    }

}
