/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;

public class OlapAddToCacheFunction extends OlapScalarEntityFunction
{
    public static final String NAME = "AddToCache";

    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3)
    {
        @Override
        public OlapFunctionArgumentType getType(int pos)
        {
            switch (pos)
            {
                case 1:
                    return OlapFunctionArgumentType.VALUE;
                default:
                    return super.getType(pos);
            }
        }
    };

    public OlapAddToCacheFunction()
    {
        super(NAME, ARGS);
    }

    @Override
    public boolean isScalar()
    {
        return false;
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args)
    {
        final String cacheName = args.toString(context, 0);
        final OlapScalarEntity value = args.toValue(context, 1, "scalar");
        final OlapMeasureGroup measureGroup = args.toMeasureGroup(context, 2);

        context.getSchema().addCache(measureGroup, cacheName, value);
        return value;
    }


}