/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@SuppressWarnings({"UnusedDeclaration"})
public class OlapVBExcelDateFunctions
{
    public static final OlapPluginUserJavaFunction NOW = new OlapPluginUserJavaFunction(0, 0)
    {
        @Override
        protected Object doEval(Object[] args)
        {
            final LocalDate ic3 = CdTimeUtils.redefinedToday();

            if(ic3 != null)
            {
                final LocalDateTime now = new LocalDateTime();

                return new LocalDateTime(
                        ic3.getYear(),
                        ic3.getMonthOfYear(),
                        ic3.getDayOfMonth(),
                        now.getHourOfDay(),
                        now.getMinuteOfHour()
                );
            }

            return LocalDateTime.now().withMillisOfSecond(0);
        }
    };

    public static abstract class OneArg extends OlapPluginUserJavaFunction
    {
        protected OneArg()
        {
            super(1, 1, Object.class);
        }

        @Override
        public final Object doEval(Object[] args) throws OlapPluginEvaluationException
        {
            final Object date = args[0];
            if (date instanceof LocalDate)
            {
                return evaluate((LocalDate) date);
            }
            if (date instanceof LocalDateTime)
            {
                return evaluate((LocalDateTime) date);
            }
            throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID, "argument type is " + date.getClass().getName());
        }

        protected abstract Object evaluate(LocalDate date);

        protected abstract Object evaluate(LocalDateTime date);
    }

    public static final OlapPluginUserJavaFunction YEAR = new OneArg()
    {
        @Override
        protected Object evaluate(LocalDate date)
        {
            return date.getYear();
        }

        @Override
        protected Object evaluate(LocalDateTime date)
        {
            return date.getYear();
        }
    };

    public static final OlapPluginUserJavaFunction MONTH = new OneArg()
    {
        @Override
        protected Object evaluate(LocalDate date)
        {
            return date.getMonthOfYear();
        }

        @Override
        protected Object evaluate(LocalDateTime date)
        {
            return date.getMonthOfYear();
        }
    };

    public static final OlapPluginUserJavaFunction DAY = new OneArg()
    {
        @Override
        protected Object evaluate(LocalDate date)
        {
            return date.getDayOfMonth();
        }

        @Override
        protected Object evaluate(LocalDateTime date)
        {
            return date.getDayOfMonth();
        }
    };
}
