/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.olapfunctions.colors;

import crazydev.common.mdx.CdMdxColorUtils;
import crazydev.iccube.plugin.olapfunctions.stats.OlapBaseInterpolateColorFunction;

/**
 * Interpolate colors in the RGB space
 *
 * InterpolateColor( numeric , array of colors )
 */
public class OlapInterpolateRGBColorsFunction extends OlapBaseInterpolateColorFunction
{
    public static final String NAME = "InterpolateRGBColors";

    public OlapInterpolateRGBColorsFunction()
    {
        super(NAME);
    }

    @Override
    protected int interpolate(int color1, int color2, double perc)
    {
        return CdMdxColorUtils.interpolateRGB(color1, color2, perc);
    }
}
