/*
 * Copyright 1999 - 2015 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.plugin.method;

import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.method.OlapModuleMethodCallInstrFactory;

public class OlapJModuleMethodCallInstr
{
    public static class Factory extends OlapModuleMethodCallInstrFactory
    {
        @Override
        public boolean isJava()
        {
            return true;
        }

        @Override
        public String getModuleName()
        {
            return "J";
        }

        @Override
        public OlapInstr createNativeFunction(OlapCompilationContext context, OlapInstrLocationRange range, MdxFunctionNativeBodyExpression mdx, String source)
        {
            return new OlapJModuleNativeFunctionInstr(range, mdx, source);
        }

    }
}
